function dateDiff(date1, date2) {
  const momentDate1 = moment(date1);
  const momentDate2 = moment(date2);
  if (!momentDate1.isValid() || !momentDate2.isValid()) {
    throw new Error('Invalid date provided');
  }
  return momentDate2.diff(momentDate1, 'days');
}


function dateAdd(date, intervalDays, intervalMonths, intervalYears) {
  const momentDate = moment(date);

  // Ensure the date is valid
  if (!momentDate.isValid()) {
    throw new Error('Invalid date provided');
  }
  const newDate = momentDate.clone()
    .add(intervalDays, 'days')
    .add(intervalMonths, 'months')
    .add(intervalYears, 'years');

  return newDate.toDate();
}

function timeAdd(date, intervalSeconds , intervalMinutes , intervalHours ) {
  // Convert input to a moment object if it isn't already
  const momentDate = moment(date);

  // Ensure the date is valid
  if (!momentDate.isValid()) {
    throw new Error('Invalid date provided');
  }

  // Create a clone to avoid modifying the original moment object
  const newDate = momentDate.clone()
    .add(intervalSeconds, 'seconds')
    .add(intervalMinutes, 'minutes')
    .add(intervalHours, 'hours');

  // Convert the moment object to a JavaScript Date object before returning
  return newDate.toDate();
}

function formatDate(date) {
    return date.toLocaleDateString()
}

function formatDateTime(date) {
    return date.toLocaleString()
}

function formatTime(date) {
    return date.toLocaleTimeString()
}

function now() {
    return new Date()
}

String.prototype.formatTemplate = function(context) {
  context = context || this;
  return this.replace(/\$\{([^}]+)\}/g, function(_, expr) {
    try {
      var f = new Function("ctx", "with(ctx) { return " + expr + "; }");
      return f(context);
    } catch (e) {
      return '${' + expr + '}';
    }
  });
};