-- -*- coding: utf-8; mode: lua -*-
-- Gペン2 by Medibang. Inc.

first_call = true
call_count = 0
pressure_ema = 0

width_high = nil
width_low = nil
pressure_alpha = nil
skip_factor = nil
cp1_pre = nil
cp1_post = nil
cp2_pre = nil
cp2_post = nil
ema_ratio = nil
r_ratio = nil
random_rotate = nil
interp_algo = nil
p_correct_val = nil

function param1()
  n = "Opacity by Pressure"
  if bs_lang() == "ja" then
    n = "筆圧不透明度"
  end
  return n, 0, 1, 0
end

function param2()
  n = "Ooze"
  if bs_lang() == "ja" then
    n = "滲み"
  end
  return n, 0, 5, 3
end

function param3()
  n = "cp1:pre"
  if bs_lang() == "ja" then
    n = "筆圧制御点A"
  end
  return n, 0, 100, 15
end

function param4()
  n = "cp1:post"
  if bs_lang() == "ja" then
    n = "筆圧制御点B"
  end
  return n, 0, 100, 20
end

function param5()
  n = "cp2:pre"
  if bs_lang() == "ja" then
    n = "筆圧制御点C"
  end
  return n, 0, 100, 85
end

function param6()
  n = "cp2:post"
  if bs_lang() == "ja" then
    n = "筆圧制御点D"
  end
  return n, 0, 100, 85
end

function param7()
  n = "Pressure EMA (%)"
  if bs_lang() == "ja" then
    n = "筆圧EMA(%)"
  end
  return n, 0, 100, 100
end

function param8()
  n = "Aspect Ratio (%)"
  if bs_lang() == "ja" then
    n = "描画点縦横比（%）"
  end
  return n, 0, 100, 50
end

function param9()
  n = "Interporation Algorythm"
  if bs_lang() == "ja" then
    n = "補完アルゴリズム"
  end
  return n, 0, 2, 2
end

function param10()
  n = "Pen Pressure"
  if bs_lang() == "ja" then
    n = "筆圧補正"
  end
  return n, 0, 10, 10
end

function default_size()
  return 15, 0
end

function init(x, y, p)
  bs_setmode(1)
  width_high = bs_width_max()
  width_low = bs_width_min()
  pressure_alpha = bs_param1() ~= 0
  skip_factor = 1
  cp1_pre = bs_param3() / 100.
  cp1_post = bs_param4() / 100.
  cp2_pre = bs_param5() / 100.
  cp2_post = bs_param6() / 100.
  ema_ratio = bs_param7() / 100.
  r_ratio = 1
  random_rotate = false
  ooze = bs_param2()
  if ooze ~= 0 then
    skip_factor = 1 + ooze
    r_ratio = bs_param8() / 100.
    random_rotate = true
  end
  interp_algo = bs_param9()
  p_correct_val = bs_param10() / 10.0
end


function change_pressure_line(p)
  ret = p
  if p ~= width_high then
    if p < cp1_pre then
      ret = (cp1_post / cp1_pre) * p + 0
    elseif p == cp1_pre then
      ret = cp1_post
    elseif cp1_pre < p and p < cp2_pre then
      ret = ((cp2_post - cp1_post) / (cp2_pre - cp1_pre)) * (p - cp1_pre) + cp1_post
    elseif p == cp2_pre then
      ret = cp2_post
    else
      ret = ((1 - cp2_post) / (1 - cp2_pre)) * (p - cp2_pre) + cp2_post
    end
  end
  return ret
end

function change_pressure_spline(p)
  function spf(xs, ys)
    local h = xs[3] - xs[2]
    function f1(n)
      return (ys[n] - ys[n - 1]) / (xs[n] - xs[n - 1])
    end
    function f2(n)
      return (f1(n + 1) - f1(n)) / (xs[n + 1] - xs[n - 1])
    end
    function sp(x)
      local x1x = x - xs[2]
      local xx2 = xs[3] - x
      local y1 = f2(2) / (h * 6) * (xx2 * xx2 * xx2)
      local y2 = f2(3) / (h * 6) * (x1x * x1x * x1x)
      local y3 = (ys[2] / h - h * f2(2) / 6) * xx2
      local y4 = (ys[3] / h - h * f2(3) / 6) * x1x
      return y1 + y2 + y3 + y4
    end
    return sp
  end

  local ret
  if p == 0 or p == 1 then
    ret = p
  elseif p == cp1_pre then
    ret = cp1_post
  elseif p == cp2_pre then
    ret = cp2_post
  elseif p < cp1_pre then
    ret = spf({-.1, 0, cp1_pre, cp2_pre}, {-.1, 0, cp1_post, cp2_post})(p)
  elseif cp1_pre < p and p < cp2_pre then
    ret = spf({0, cp1_pre, cp2_pre, 1}, {0, cp1_post, cp2_post, 1})(p)
  else
    ret = spf({cp1_pre, cp2_pre, 1, 1.1}, {cp1_post, cp2_post, 1, 1.1})(p)
  end
  return ret
end

function change_pressure(p)
  local ret
  if interp_algo == 0 then
    ret = p
  elseif interp_algo == 1 then
    ret = change_pressure_line(p)
  elseif interp_algo == 2 then
    ret = change_pressure_spline(p)
  end
  ret = ret * ema_ratio + pressure_ema * (1 - ema_ratio)
  ret = math.pow(ret, 1 + p_correct_val)
  pressure_ema = ret
  return ret
end


function main(x, y, p)

  if first_call then
    init(x, y, p)
    first_call = false
  end

  call_count = call_count + 1
  if call_count % skip_factor ~= 0 then
    return 0
  end

  local r, g, b = bs_fore()
  local o = bs_opaque()
  local p2 = change_pressure(p)
  local w = width_low + (width_high - width_low) * p2
  local a = 255 * o
  if pressure_alpha then
    a = a * p2
  end
  local dx, dy = bs_dir()
  local rad = bs_atan(dx, dy)
  if random_rotate then
    rad = 3.1415 * (math.random(200) - 100) / 100
  end

  bs_ellipse(x, y, w * r_ratio, w, rad, r, g, b, a)
  return 1
end
