// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform mat4 mBlendMatrix;
uniform mat4 mTagMatrix;
uniform int showTag;
uniform int showShadow;
uniform int mIsSwapping;
uniform float mLimitPosition[4];
const float threshold = 0.005;

vec4 shadowColor = vec4(0.0, 0.0, 0.0, 0.4);

bool isOutside(vec2 uv) {
    return uv.x < 0.0 || uv.x > 1.0 || uv.y < 0.0 || uv.y > 1.0;
}

void main()
{
    vec4 coordinate = vec4(textureCoordinate, 0.0, 1.0);
    coordinate = mBlendMatrix * coordinate;
    vec4 areaColor = texture2D(inputImageTexture2, textureCoordinate);

    if (isOutside(coordinate.xy)) {
        if (showShadow == 1 && areaColor.a > 0.0) {
            // 显示阴影颜色，透明度基于 areaColor.a
            gl_FragColor = vec4(shadowColor.rgb, shadowColor.a * areaColor.a);
        } else {
            // 否则输出透明色
            gl_FragColor = vec4(0.0);
        }
        return;
    }

    vec4 srcColor = texture2D(inputImageTexture, coordinate.xy);  // 主纹理颜色

    float parms = threshold;
    if (abs(coordinate.x) < threshold) {
        parms = abs(coordinate.x);
    } else if (abs(coordinate.x - 1.0) < threshold) {
        parms = abs(coordinate.x - 1.0);
    } else if (abs(coordinate.y) < threshold) {
        parms = abs(coordinate.y);
    } else if (abs(coordinate.y - 1.0) < threshold) {
        parms = abs(coordinate.y - 1.0);
    }
    parms = parms / threshold;
    srcColor = srcColor * parms;

    vec4 result = areaColor.a * srcColor;  // 默认的区域混合逻辑

    // 添加阴影逻辑，仅当 showShadow == 1 时执行
    if (showShadow == 1) {
        result.rgb = mix(result.rgb, shadowColor.rgb, shadowColor.a);
        shadowColor.a = shadowColor.a * areaColor.a;
        result.a = result.a + shadowColor.a * (1.0 - result.a);
    }

    if (showTag == 1) {
        vec4 tagCoor = vec4(textureCoordinate, 0.0, 1.0);
        tagCoor = mTagMatrix * tagCoor;
        // 添加边界检查
        if (!isOutside(tagCoor.xy)) {
            vec4 tagColor = texture2D(inputImageTexture3, tagCoor.xy);
            result = mix(result, tagColor, tagColor.a);
        }
    }

    if (mIsSwapping == 1) {
        gl_FragColor = srcColor;
    } else {
        gl_FragColor = result;
    }
}