precision mediump float;


varying highp vec2 textureCoordinate; // 原图纹理坐标
varying highp vec2 textureCoordinate2; // mask纹理坐标

// 底图
uniform sampler2D inputImageTexture;
// mask
uniform sampler2D inputImageTexture2;

// 贴图矩阵
uniform mat4 mMaskMatrix;

uniform float alphaPercent;

void main() {
    vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    // mask纹理坐标变换
    highp vec4 maskCoordinate = vec4(textureCoordinate2, 0.0, 1.0);
    maskCoordinate = mMaskMatrix * maskCoordinate;

    if (maskCoordinate.x < 0.0 || maskCoordinate.x > 1.0 || maskCoordinate.y < 0.0 || maskCoordinate.y > 1.0) {
        gl_FragColor = baseColor;
        return;
    }

    // mask纹理采样
    vec4 maskColor = texture2D(inputImageTexture2, maskCoordinate.xy) * alphaPercent;
    gl_FragColor = baseColor * (1.0 - maskColor.a) + maskColor;
}

