////// Fragment Shader
precision mediump float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform vec3 redShift;
uniform vec3 orangeShift;
uniform vec3 yellowShift;
uniform vec3 greenShift;
uniform vec3 aquaShift;
uniform vec3 blueShift;
uniform vec3 purpleShift;
uniform vec3 magentaShift;


const float red = 0.0;
const float orange = 0.082815;
const float yellow = 0.16666667;
const float green = 0.33333334;
const float aqua = 0.5;
const float blue = 0.6666667;
const float purple = 0.749482;
const float magenta = 0.8333333;
const mediump vec3 luminanceWeighting = vec3(0.2126, 0.7152, 0.0722);

uniform int count;
uniform vec3 items_sourceHSV[10];
uniform vec3 items_destinationHSV[10];
uniform vec2 items_effectedHueLength[10];


vec3 rgb2hsv(vec3 color)
{
    vec3 hsl;
    float fmin = min(min(color.r, color.g), color.b);
    float fmax = max(max(color.r, color.g), color.b);
    float delta = fmax - fmin;
    hsl.z = (fmax + fmin) / 2.0;
    if (delta == 0.0) {
        hsl.x = 0.0;
        hsl.y = 0.0;
    } else {
        if (hsl.z < 0.5) {
            hsl.y = delta / (fmax + fmin);
        } else {
            hsl.y = delta / (2.0 - fmax - fmin);
        }
        float deltaR = (((fmax - color.r) / 6.0) + (delta / 2.0)) / delta;
        float deltaG = (((fmax - color.g) / 6.0) + (delta / 2.0)) / delta;
        float deltaB = (((fmax - color.b) / 6.0) + (delta / 2.0)) / delta;
        if (color.r == fmax) {
            hsl.x = deltaB - deltaG;
        } else if (color.g == fmax) {
            hsl.x = (1.0 / 3.0) + deltaR - deltaB;
        } else if (color.b == fmax) {
            hsl.x = (2.0 / 3.0) + deltaG - deltaR;
        }
        if (hsl.x < 0.0) {
            hsl.x += 1.0;
        } else if (hsl.x > 1.0) {
            hsl.x -= 1.0;
        }
    }
    return hsl;
}

vec3 hsv2rgb(vec3 hsl)
{
    if (hsl.y == 0.0) {
        return vec3(hsl.z);
    } else {
        float f2;
        if (hsl.z < 0.5) {
            f2 = hsl.z * (1.0 + hsl.y);
        } else {
            f2 = (hsl.z + hsl.y) - (hsl.y * hsl.z);
        }
        float f1 = 2.0 * hsl.z - f2;
        float r;
        float g;
        float b;
        float hue1 = hsl.x + (1.0 / 3.0);
        if (hue1 < 0.0) {
            hue1 = hue1 + 1.0;
        } else if (hue1 > 1.0) {
            hue1 = hue1 - 1.0;
        }
        if ((6.0 * hue1) < 1.0) {
            r = f1 + (f2 - f1) * 6.0 * hue1;
        } else if ((2.0 * hue1) < 1.0) {
            r = f2;
        } else if ((3.0 * hue1) < 2.0) {
            r = f1 + (f2 - f1) * ((2.0 / 3.0) - hue1) * 6.0;
        } else {
            r = f1;
        }

        float hue2 = hsl.x;
        if (hue2 < 0.0) {
            hue2 = hue2 + 1.0;
        } else if (hue2 > 1.0) {
            hue2 = hue2 - 1.0;
        }
        if ((6.0 * hue2) < 1.0) {
            g = f1 + (f2 - f1) * 6.0 * hue2;
        } else if ((2.0 * hue2) < 1.0) {
            g = f2;
        } else if ((3.0 * hue2) < 2.0) {
            g = f1 + (f2 - f1) * ((2.0 / 3.0) - hue2) * 6.0;
        } else {
            g = f1;
        }

        float hue3 = hsl.x - (1.0 / 3.0);
        if (hue3 < 0.0) {
            hue3 = hue3 + 1.0;
        } else if (hue3 > 1.0) {
            hue3 = hue3 - 1.0;
        }
        if ((6.0 * hue3) < 1.0) {
            b = f1 + (f2 - f1) * 6.0 * hue3;
        } else if ((2.0 * hue3) < 1.0) {
            b = f2;
        } else if ((3.0 * hue3) < 2.0) {
            b = f1 + (f2 - f1) * ((2.0 / 3.0) - hue3) * 6.0;
        } else {
            b = f1;
        }
        return vec3(r, g, b);
    }
}

vec3 smoothTreatmentH(vec3 hsv, float hueEdge0, float hueEdge1, vec3 shiftEdge0, vec3 shiftEdge1)
{
    float smoothedHue = smoothstep(hueEdge0, hueEdge1, hsv.x);
    float hue = hsv.x + (shiftEdge0.x + ((shiftEdge1.x - shiftEdge0.x) * smoothedHue));
    float sat = hsv.y * (shiftEdge0.y + ((shiftEdge1.y - shiftEdge0.y) * smoothedHue));
    return vec3(hue, sat, hsv.z);
}

vec3 smoothTreatmentS(vec3 rgb, float saturation, float start, float middle0, float middle1, float end, float location)
{
    float f;
    float satOffset;
    if (location < middle0) {
        f = (middle0 - location) / (middle0 - start);
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f : saturation + (1.0 - saturation) * f;
    } else if (location > middle1) {
        f = (location - middle1) / (end - middle1);
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f : saturation + (1.0 - saturation) * f;
    } else {
        satOffset = saturation;
    }
    float luminance = dot(rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);
    return vec3(mix(greyScaleColor, rgb, satOffset));
}

vec3 smoothTreatmentSM(vec3 rgb, float saturation, float start, float middle0, float middle1, float end, float location)
{
    float f;
    float satOffset;
    if (location < middle0) {
        f = (middle0 - location) / (middle0 - start);
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f : saturation + (1.0 - saturation) * f;
    } else if (location > middle1) {
        f = (location - middle1) / (end - middle1);
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f : saturation + (1.0 - saturation) * f * f;
    } else {
        satOffset = saturation;
    }
    float luminance = dot(rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);
    return vec3(mix(greyScaleColor, rgb, satOffset));
}

vec3 smoothTreatmentSA(vec3 rgb, float saturation, float start, float middle0, float middle1, float end, float location)
{
    float f;
    float satOffset;
    if (location < middle0) {
        f = (middle0 - location) / (middle0 - start);
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f : saturation + (1.0 - saturation) * f * f;
    } else if (location > middle1) {
        f = (location - middle1) / (end - middle1);
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f : saturation + (1.0 - saturation) * f * f;
    } else {
        satOffset = saturation;
    }
    float luminance = dot(rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);
    return vec3(mix(greyScaleColor, rgb, satOffset));
}

vec3 smoothTreatmentSO(vec3 rgb, float saturation, float start, float middle0, float middle1, float end, float location)
{
    float f;
    float satOffset;
    if (location < middle0) {
        f = (middle0 - location) / (middle0 - start);
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f * f : saturation + (1.0 - saturation) * f * f;
    } else if (location > middle1) {
        f = (location - middle1) / (end - middle1);
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f : saturation + (1.0 - saturation) * f;
    } else {
        satOffset = saturation;
    }
    float luminance = dot(rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);
    return vec3(mix(greyScaleColor, rgb, satOffset));
}

vec3 smoothTreatmentSOrange2(vec3 rgb, float saturation, float middle, float end, float location)
{
    float f;
    float satOffset;
    if (location > end) {
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) + (saturation - 1.0) * 0.8 : saturation + (1.0 - saturation) * 0.2;
    } else {
        f = 0.8 + 0.6 * (location - middle) / (middle - end);
        if (saturation > 1.0) {
            satOffset = saturation - (saturation - 1.0) + (saturation - 1.0) * (1.0 - f) * 2.0;
        } else {
            satOffset = saturation + (1.0 - saturation) * f;
        }
    }
    float luminance = dot(rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);
    return vec3(mix(greyScaleColor, rgb, satOffset));
}

vec3 smoothTreatmentL(vec3 hsv, float min, float middle, float max, vec3 shiftEdge0)
{
    float f = hsv.x > middle ? (middle - hsv.x) / (max - middle) : (middle - hsv.x) / (middle - min);
    float shiftZ = hsv.z > 0.5 ? (hsv.z - 0.5) / 0.5 : (0.5 - hsv.z) / 0.5;
    float shift = (1.0 - shiftZ) * (1.0 - shiftZ) * (shiftEdge0.z - 1.0) * (5.0 - hsv.y * 3.) * hsv.y;
    float lumOffset = (1.0 - f * f) * shift + 1.0;
    float lum = clamp(hsv.z * lumOffset, 0., 1.);
    return vec3(hsv.x, hsv.y, lum);
}

void main()
{
    vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    if (baseColor.a == 0.0) {
        gl_FragColor = vec4(0);
        return;
    }
    vec3 hsv = rgb2hsv(baseColor.rgb);

    //S 调节
    vec3 rgb = baseColor.rgb;
    if (hsv.x >= 0.0 && hsv.x < 0.125) {
        //0--45橙色
        rgb = smoothTreatmentSO(rgb, orangeShift.y, -0.1, 0.078, orange, 0.125, hsv.x);// -  28 30  45
    }
    if (hsv.x > 0.9444 && hsv.x <= 1.0) {
        //340--360 橙色
        rgb = smoothTreatmentSOrange2(rgb, orangeShift.y, 0.9444, 0.972, hsv.x);//340 350 360
    }
    if (hsv.x >= 0.069 && hsv.x < 0.264) {
        //25--95 黄色
        rgb = smoothTreatmentS(rgb, yellowShift.y, 0.069, 0.1111, 0.194, 0.264, hsv.x);//25   40 70  90
    }
    if (hsv.x >= yellow && hsv.x < 0.5) {
        //60--180 绿色
        rgb = smoothTreatmentSM(rgb, greenShift.y, orange, 0.25, 0.43, 0.5, hsv.x);// 30  90  155  180
    }
    if (hsv.x >= 0.41 && hsv.x < 0.67) {
        //150--240天蓝
        rgb = smoothTreatmentSA(rgb, aquaShift.y, 0.41, 0.5, 0.51, 0.67, hsv.x);//150  180 ,180  240
    }

    if (hsv.x >= 0.777 && hsv.x < 0.96) {
        //280--340平红
        rgb = smoothTreatmentSA(rgb, magentaShift.y, 0.777, 0.88, 0.8833, 0.96, hsv.x);// 280  310 318  360
    }

    if (hsv.x >= 0.861 && hsv.x < 1.0) {
        //310--360红
        rgb = smoothTreatmentS(rgb, redShift.y, 0.861, 0.944, 0.96, 1.0, hsv.x);// 310  340 345  352
    }

    hsv = rgb2hsv(rgb);

    //  L调节
    if (hsv.x < 0.125) {
        //0-45 橙色
        hsv = smoothTreatmentL(hsv, 0.0, orange, 0.125, orangeShift);
    } if (hsv.x >= 0.0416666666 && hsv.x < 0.333) {
    //15--120 黄色
    hsv = smoothTreatmentL(hsv, 0.0416666666, yellow, 0.333, yellowShift);
} if (hsv.x >= yellow && hsv.x < aqua) {
    //60--180  // 绿色
    hsv = smoothTreatmentL(hsv, yellow, green, aqua, greenShift);
} if (hsv.x >= green && hsv.x < blue) {
    //150--240 青色
    hsv = smoothTreatmentL(hsv, green, aqua, blue, aquaShift);
} if (hsv.x >= aqua && hsv.x < purple) {
    //180--240  //蓝色
    hsv = smoothTreatmentL(hsv, aqua, blue, purple, blueShift);
} if (hsv.x >= blue && hsv.x < magenta) {
    //240--300  //紫色
    hsv = smoothTreatmentL(hsv, blue, purple, magenta, purpleShift);
} if (hsv.x >= purple && hsv.x < 0.99999999) {
    //270--360  品红
    hsv = smoothTreatmentL(hsv, purple, magenta, 1.0, magentaShift);
} if (hsv.x < orange) {
    //0--30  红
    hsv = smoothTreatmentL(hsv, -0.1, 0.0, orange, redShift);
} if (hsv.x > magenta) {
    ///300--360 红
    hsv = smoothTreatmentL(hsv, magenta, 1.0, 1.1, redShift);
}
    //
    if (hsv.x < orange) {
        hsv = smoothTreatmentH(hsv, 0.0, orange, redShift, orangeShift);
    } else if (hsv.x >= orange && hsv.x < yellow) {
        hsv = smoothTreatmentH(hsv, orange, yellow, orangeShift, yellowShift);
    } else if (hsv.x >= yellow && hsv.x < green) {
        hsv = smoothTreatmentH(hsv, yellow, green, yellowShift, greenShift);
    } else if (hsv.x >= green && hsv.x < aqua) {
        hsv = smoothTreatmentH(hsv, green, aqua, greenShift, aquaShift);
    } else if (hsv.x >= aqua && hsv.x < blue) {
        hsv = smoothTreatmentH(hsv, aqua, blue, aquaShift, blueShift);
    } else if (hsv.x >= blue && hsv.x < purple) {
        hsv = smoothTreatmentH(hsv, blue, purple, blueShift, purpleShift);
    } else if (hsv.x >= purple && hsv.x < magenta) {
        hsv = smoothTreatmentH(hsv, purple, magenta, purpleShift, magentaShift);
    } else if (hsv.x >= magenta) {
        hsv = smoothTreatmentH(hsv, magenta, 0.99999999, magentaShift, redShift);
    }

    // 自定义取色器
    vec3 resultHSV = hsv;
    for (int i = 0; i < count; i++) {
        vec3 originalHSV = hsv;
        vec3 sourceHSV = items_sourceHSV[i];
        vec3 destinationHSV = items_destinationHSV[i];
        float leadingLength = items_effectedHueLength[i].x;
        float trailingLength = items_effectedHueLength[i].y;
        if (originalHSV.x - sourceHSV.x > 0.5) {
            originalHSV.x -= 1.0;
        } else if (sourceHSV.x - originalHSV.x > 0.5) {
            originalHSV.x += 1.0;
        }
        float hueWeight = 0.0;
        if (originalHSV.x < sourceHSV.x && sourceHSV.x - originalHSV.x <= leadingLength) {
            hueWeight = 1.0 - (sourceHSV.x - originalHSV.x) / leadingLength;
        } else if (originalHSV.x > sourceHSV.x && originalHSV.x - sourceHSV.x < trailingLength) {
            hueWeight = 1.0 - (originalHSV.x - sourceHSV.x) / trailingLength;
        } else if (originalHSV.x == sourceHSV.x) {
            hueWeight = 1.0;
        }
        hueWeight = smoothstep(0.0, 1.0, hueWeight);
        if (hueWeight == 0.0) {
            continue;
        }

        if (destinationHSV.x - sourceHSV.x > 0.5) {
            destinationHSV.x -= 1.0;
        } else if (sourceHSV.x - destinationHSV.x > 0.5) {
            destinationHSV.x += 1.0;
        }
        float hueOffset = (destinationHSV.x - sourceHSV.x) * hueWeight;
        resultHSV.x = fract(resultHSV.x + hueOffset);

        // 图片颜色小于取色器颜色时，饱和度根据差值进行调整
        float saturationWeight = originalHSV.y >= sourceHSV.y ? 1.0 : 1.0 - (sourceHSV.y - originalHSV.y) / sourceHSV.y;
        saturationWeight = smoothstep(0.0, 1.0, saturationWeight);
        if (saturationWeight == 0.0) {
            continue;
        }
        float saturationOffset = 0.0;
        if (destinationHSV.y  < sourceHSV.y){
            // 目标颜色饱和度小于取色器颜色饱和度时，饱和度根据差值进行调整，直到完全变灰
            saturationOffset = (destinationHSV.y - sourceHSV.y)/(sourceHSV.y * 0.6) * hueWeight * saturationWeight * resultHSV.y;
        } else {
            // 当前分支逻辑与peachy保持一致
            saturationOffset = (destinationHSV.y - sourceHSV.y)* hueWeight * saturationWeight;
        }
        resultHSV.y = clamp(resultHSV.y + saturationOffset, 0.0, 1.0);

        if (destinationHSV.z != sourceHSV.z) {
            float lightnessOffset = 0.0;
            if (destinationHSV.z < sourceHSV.z) {
                // 目标颜色亮度小于取色器颜色亮度时，亮度根据差值进行调整，/3的原因是为了不让亮度值变成0，导致图片变成黑色
                lightnessOffset = (destinationHSV.z - sourceHSV.z) / (sourceHSV.z * 0.2)  * hueWeight * saturationWeight * resultHSV.z / 3.;
            } else {
                // 当前分支逻辑与peachy保持一致
                lightnessOffset =  (destinationHSV.z - sourceHSV.z)* hueWeight * saturationWeight;
            }
            resultHSV.z = clamp(resultHSV.z + lightnessOffset, 0.0, 1.0);
        }
    }

    gl_FragColor = vec4(hsv2rgb(resultHSV), baseColor.a);
}
