//Fragment Shader
precision highp float;

const int TYPE_SAVE = 2;

varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

varying highp vec2 textureCoordinate2;
uniform sampler2D inputImageTexture2;

varying highp vec2 textureCoordinate3;
uniform sampler2D inputImageTexture3;

uniform mat4 maskMatrix;
uniform int drawType;

void main() {
    highp vec4 maskCoordinate = vec4(textureCoordinate3, 0.0, 1.0);
    maskCoordinate = maskMatrix * maskCoordinate;
    vec4 maskColor = texture2D(inputImageTexture3, maskCoordinate.xy);
    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 blendColor = texture2D(inputImageTexture2, textureCoordinate);
    if (drawType == TYPE_SAVE) {
        if (maskCoordinate.x >= 0.0 && maskCoordinate.x <= 1.0 && maskCoordinate.y >= 0.0 && maskCoordinate.y <= 1.0) {
            if (maskColor.a == 1.0) {
                gl_FragColor = blendColor;
                return;
            }
        }
    }

    gl_FragColor = srcColor * (1.0 - blendColor.a) + blendColor;
}