precision mediump float;

const int TYPE_SAVE = 2;

varying highp vec2 textureCoordinate; // 原图纹理坐标
varying highp vec2 textureCoordinate2; // mask纹理坐标

// 底图
uniform sampler2D inputImageTexture;
// mask
uniform sampler2D inputImageTexture2;
// stroke
uniform sampler2D inputImageTexture3;

// 放大矩阵
uniform mat4 mMagnifyScaleMatrix;
// 描边
uniform mat4 mStrokeMatrix;
// 贴图矩阵
uniform mat4 mMaskMatrix;
uniform int drawType;
uniform float showRatio;
uniform int hasStroke;


vec4 getAlphaColor(vec2 xy) {
    float xCount = 50.0;
    float yCount = 50.0;

    if (showRatio > 1.0) {
        yCount = xCount / showRatio;
    } else {
        xCount = yCount * showRatio;
    }
    float xPosition = floor(xy.x * xCount);
    float yPosition = floor(xy.y * yCount);
    if (mod(xPosition + yPosition, 2.0) > 0.1) {
        return vec4(0.47, 0.47, 0.47, 1.0);
    } else {
        return vec4(0.75, 0.75, 0.75, 1.0);
    }
}

void main() {
    // 放大镜纹理坐标变换
    highp vec4 magnifyCoordinate = vec4(textureCoordinate, 0.0, 1.0);
    magnifyCoordinate = mMagnifyScaleMatrix * magnifyCoordinate;

    // 描边纹理坐标变换
    highp vec4 strokeCoordinate = vec4(textureCoordinate2, 0.0, 1.0);
    strokeCoordinate = mStrokeMatrix * strokeCoordinate;
    // mask纹理坐标变换
    highp vec4 maskCoordinate = vec4(textureCoordinate2, 0.0, 1.0);
    maskCoordinate = mMaskMatrix * maskCoordinate;
    // 检查描边是否超出范围
    if (strokeCoordinate.x < 0.0 || strokeCoordinate.x > 1.0 || strokeCoordinate.y < 0.0 || strokeCoordinate.y > 1.0) {
        gl_FragColor = vec4(0.0);
        return;
    }

    vec4 base = texture2D(inputImageTexture, magnifyCoordinate.xy);

    if (magnifyCoordinate.x < 0.0 || magnifyCoordinate.x > 1.0 || magnifyCoordinate.y < 0.0 || magnifyCoordinate.y > 1.0) {
        // 超出范围显示黑色
        base = vec4(0.0, 0.0, 0.0, 1.0);
    } else if (base.a < 1.0) {
        if (drawType != TYPE_SAVE) {
            //将底图与方格子图进行合成
            vec4 alphaColor = getAlphaColor(magnifyCoordinate.xy);
            base = alphaColor * (1.0 - base.a) + base;
        }
    }

    // 根据mask的alpha值获取显示效果
    vec4 maskColor = texture2D(inputImageTexture2, maskCoordinate.xy);
    vec4 result = base * maskColor.a;
    // 如果mask超出范围，就显示透明，防止mask与描边叠图后出现其他多余的像素
    if (maskCoordinate.x < 0.0 || maskCoordinate.x > 1.0 || maskCoordinate.y < 0.0 || maskCoordinate.y > 1.0) {
        result = vec4(0.0);
    }

    // 是否显示描边
    if (hasStroke == 1) {
        vec4 stroke = texture2D(inputImageTexture3, strokeCoordinate.xy);
        if (drawType == TYPE_SAVE) {
            // 保存的时候，防止当底图带有透明度的时候，mask图片无法完整的覆盖住描边的问题
            if (maskCoordinate.x > 0.0 && maskCoordinate.x < 1.0 && maskCoordinate.y > 0.0 && maskCoordinate.y < 1.0) {
                result = stroke * (1.0 - maskColor.a) + result;
                gl_FragColor = result;
                return;
            }
        }
        result = stroke * (1.0 - result.a) + result;
    }
    gl_FragColor = result;
}
