precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform highp vec2 inputSize;
uniform highp float iTime;

uniform int level;
uniform highp float effectValue;


void main() {
    vec2 uv = textureCoordinate;
    float ratio = inputSize.x / inputSize.y;
    vec2 st = uv;
    st.x *= 32.0;
    st.x = fract(st.x);

    float w = 0.1;
    float s = 0.3;
    float c = smoothstep(w, w+s, st.x) - smoothstep(2.0*w+s, 2.0*w+3.0*s, st.x);
    gl_FragColor = vec4(vec3(c), 1.0);
}