////// Fragment Shader
precision highp float;

// 从顶点着色器传入的纹理坐标
varying vec2 textureCoordinate;
varying vec2 textureCoordinate2;

// 主纹理 & 掩码纹理
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2; // mask

// 相关控制参数
uniform float effectValue;     // 位移强度
uniform float frequencyScale;  // 新增：波长缩放控制
uniform vec2 inputSize;
uniform int mode;              // 0 = 双向位移, 1 = 仅水平, 2 = 仅垂直
uniform bool preprocess;

void main()
{
    if (effectValue <= 0.0) {
        gl_FragColor = texture2D(inputImageTexture, textureCoordinate);
        return;
    }
    // 1. 用 scaledUV 来采样掩码纹理，从而调整波形“频率”
    //    若 frequencyScale < 1.0 => 波长变大，波峰波谷更稀疏
    //    若 frequencyScale > 1.0 => 波长变小，波峰波谷更密集
    vec2 scaledUV = textureCoordinate * effectValue;
    vec4 mapMask = texture2D(inputImageTexture2, scaledUV);

    // 2. 如果需要预处理，则对红色通道进行一定的移位和缩放
    if (preprocess) {
        // 这通常用于把 [-1,1] 转到 [0,1] 或反之
        mapMask.r += 1.0;
        mapMask.r *= 0.5;
    }

    // 3. 根据掩码红色通道计算位移量
    //    其中 0.05 是硬编码系数，可自行加大或减小
    float offset = 0.05 * (mapMask.r - 0.5) * 2.0 * mapMask.a;

    // 4. 先将主纹理的坐标取出来，再应用位移
    vec2 uv = textureCoordinate;

    // 5. 根据 mode 决定位移方向
    //    mode == 1 => 仅水平
    //    mode == 2 => 仅垂直
    //    否则（默认 0） => x, y 同时做位移(一个正，一个负)
    if (mode == 1) {
        uv.x += offset;
    } else if (mode == 2) {
        uv.y += offset;
    } else {
        uv.x += offset;
        uv.y -= offset;
    }

    // 6. 做镜像包裹，以避免简单重复引起的接缝或拉伸
    uv += 1.0;
    uv *= 0.5;
    uv = fract(uv);
    uv = abs((uv - 0.5) * 2.0);

    // 7. 最终使用变换后的 uv 在主纹理采样并输出
    gl_FragColor = texture2D(inputImageTexture, uv);
}