////// Fragment Shader

const int GLITCH_TYPE = 0;
const int GLASS_TYPE_ChromaticDrift = 1;
const int GLASS_TYPE_HorizontalGhost = 2;
const int GLASS_TYPE_RGB = 3;


precision highp float;
varying vec2 textureCoordinate;
varying vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;//mask
uniform float effectValue;
uniform vec2 inputSize;
uniform bool useMask;
uniform int type;
float SHIFT_AMOUNT = 0.006;


void main()
{
    vec2 uv = textureCoordinate;
    float maskValue = useMask ? texture2D(inputImageTexture2, uv).r : 1.0;
    float ratio = inputSize.x / inputSize.y;

    float dis = distance(uv, vec2(0.5));
    float w = smoothstep(0.0, 0.45, dis);
    if (type == 3) {
        SHIFT_AMOUNT = 0.01;
    }
    float offsetX = SHIFT_AMOUNT * ratio * maskValue * w;
    float offsetY = SHIFT_AMOUNT * maskValue * w;

    vec4 color = texture2D(inputImageTexture, uv);
    if (type == 0) {
        gl_FragColor = color;
        return;
    }

    uv.x += offsetX * effectValue;
    if (type == 1) {
        uv.y -= offsetY * effectValue;
    }
    uv += 1.0;
    uv *= 0.5;
    uv = fract(uv);
    uv = abs((uv - 0.5) * 2.0);
    vec4 color1 = texture2D(inputImageTexture, uv);

    uv = textureCoordinate;
    uv.x -= offsetX * effectValue;
    if (type == 1) {
        uv.y += offsetY * effectValue;
    }
    uv += 1.0;
    uv *= 0.5;
    uv = fract(uv);
    uv = abs((uv - 0.5) * 2.0);
    vec4 color2 = texture2D(inputImageTexture, uv);
    if (type == 1) {
        gl_FragColor = vec4(color1.r, color.g, color2.b, color.a);
        return;
    } else if (type == 2) {
        gl_FragColor = vec4(color2.r, color1.g, color1.b, color.a);
        return;
    }else if (type == 3) {
        gl_FragColor = vec4(color1.r, color.g, color2.b, color.a);
        return;
    }
}