////// Fragment Shader
precision highp float;
varying vec2 textureCoordinate;
varying vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;//mask
uniform float effectValue;
uniform vec2 inputSize;

void main()
{
    vec2 uv = textureCoordinate;
    vec4 mapMask = texture2D(inputImageTexture2, uv);
    float ratio = inputSize.x / inputSize.y;
    float offsetX = (mapMask.r - 0.5);
    float offsetY = (mapMask.g - 0.5);

    offsetX *= step(0.0045, abs(offsetX)) * 0.3;
    offsetY *= step(0.0045, abs(offsetY)) * 0.3;

    uv.x += offsetX * effectValue;
    uv.y -= offsetY * effectValue;

    uv += 1.0;
    uv *= 0.5;
    uv = fract(uv);
    uv = abs((uv-0.5) * 2.0);

    gl_FragColor = texture2D(inputImageTexture, uv);
}