////// Fragment Shader
precision highp float;
varying vec2 textureCoordinate;
varying vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;//blur image
uniform float effectValue;
uniform vec2 inputSize;

void main()
{
    vec2 uv = textureCoordinate;
    vec4 orgColor = texture2D(inputImageTexture, uv);
    vec4 blurColor = texture2D(inputImageTexture2, uv);
    float dis = distance(uv, vec2(0.5));
    float w = smoothstep(0.45, 0.6, dis);

    gl_FragColor = mix(orgColor, blurColor, w);
}