////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform int premulti;

vec4 unpremultiply(vec4 s) {
    return vec4(s.rgb/max(s.a,0.00001), s.a);
}

vec4 premultiply(vec4 s) {
    return vec4(s.rgb * s.a, s.a);
}

vec4 normalBlend(vec4 Cb, vec4 Cs) {
    vec4 dst = premultiply(Cb);
    vec4 src = premultiply(Cs);
    return unpremultiply(src + dst * (1.0 - src.a));
}

vec4 normalBlendNoPremultiply(vec4 Cb, vec4 Cs) {
    vec4 dst = (Cb);
    vec4 src = (Cs);
    return unpremultiply(src + dst * (1.0 - src.a));
}

void main()
{
    vec4 color1 = texture2D(inputImageTexture, textureCoordinate);
    vec4 color2 = texture2D(inputImageTexture2, textureCoordinate2);//glass
    if(color1.a < 0.95) {
        gl_FragColor = mix(color1, color2, color2.a);
    } else if(premulti == 1) {
        gl_FragColor = normalBlend(color1, color2);
    } else {
        gl_FragColor = normalBlendNoPremultiply(color1, color2);
    }
}