////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;// 已经裁剪的纹理
uniform sampler2D inputImageTexture2;// 背景纹理
uniform mat4 mBlendMatrix;
uniform mat4 mBgMatrix;
uniform float gradientColor[21];
uniform int gradientCount;
uniform float degree;
uniform float width;
uniform float height;
uniform int mBgType;
uniform highp vec2 repeatCount;

vec4 drawGradientBg(){
    float degreeResult=360.-degree*3.55;
    float gradientDegree;
    if (degreeResult>=0.&&degreeResult<90.){
        gradientDegree=degreeResult;
    } else if (degreeResult>90.&&degreeResult<=180.){
        gradientDegree=degreeResult-90.;
    } else if (degreeResult>180.&&degreeResult<=270.){
        gradientDegree=degreeResult-180.;
    } else {
        gradientDegree=degreeResult-270.;
    }

    float radian=radians(gradientDegree);
    float newWdith=width*(cos(radian))+height*(sin(radian));
    float newHeight=width*(sin(radian))+height*(cos(radian));

    float posx=textureCoordinate.x*width;
    float posy=textureCoordinate.y*height;

    float newY=0.;
    if (degreeResult>=0.&&degreeResult<90.)
    newY=posy*cos(radian)+(width-posx)*sin(radian);
    else if (degreeResult>=90.&&degreeResult<=180.){
        float temp=newWdith;
        newWdith=newHeight;
        newHeight=temp;
        newY=newHeight-(posx*cos(radian)+posy*sin(radian));
    } else if (degreeResult>180.&&degreeResult<=270.){
        newY=(height-posy)*cos(radian)+posx*sin(radian);
    } else {
        float temp=newWdith;
        newWdith=newHeight;
        newHeight=temp;
        newY=posx*cos(radian)+posy*sin(radian);
    }
    float percent=newY/newHeight;
    float indexF=percent*(float(gradientCount)-1.);
    int index=int(indexF);
    float off=indexF-float(index);
    vec3 curPix;
    curPix.r=gradientColor[0+index*3]+(gradientColor[3+index*3]-gradientColor[0+index*3])*off;
    curPix.g=gradientColor[1+index*3]+(gradientColor[4+index*3]-gradientColor[1+index*3])*off;
    curPix.b=gradientColor[2+index*3]+(gradientColor[5+index*3]-gradientColor[2+index*3])*off;
    return vec4(curPix, 1.);
}

vec4 drawPhotoBg(){
    float percentWidth, percentHeight, resultX, resultY;
    int indexX, indexY;
    percentWidth=1./repeatCount.x;
    indexX=int(textureCoordinate.x/percentWidth);
    resultX=(textureCoordinate.x-float(indexX)*percentWidth)/percentWidth;
    percentHeight=1./repeatCount.y;
    indexY=int(textureCoordinate.y/percentHeight);
    resultY=(textureCoordinate.y-float(indexY)*percentHeight)/percentHeight;
    return texture2D(inputImageTexture, vec2(resultX, resultY));
}
vec4 drawBlurBg(){
    vec4 srcColor=texture2D(inputImageTexture, textureCoordinate);
    vec4 defaultColor=vec4(.14, .14, .14, 1.);
    return defaultColor*(1.-srcColor.a)+srcColor;
}

vec4 getShowColorWithTranslucenta(vec4 bgColor, vec4 srcColor, vec4 maskColor){
    vec4 translucentaColor=vec4(0, 0, 0, .5);
    if (maskColor.a==0.){
        vec4 result=bgColor*(1.-srcColor.a)+srcColor;
        return result*translucentaColor.a+translucentaColor;
    } else if (maskColor.a==1.){
        return srcColor*srcColor.a+bgColor*(1.-srcColor.a);
    } else {
        maskColor=maskColor*translucentaColor.a;
        if (srcColor.a==0.){
            return bgColor*(1.-maskColor.a)+maskColor;
        } else if (srcColor.a==1.){
            vec3 result=srcColor.rgb*(1.-maskColor.a)+translucentaColor.rgb*maskColor.a;
            return vec4(result, 1.);
        } else {
            vec4 result=srcColor*(1.-maskColor.a*srcColor.a)+translucentaColor*maskColor.a*srcColor.a;
            return bgColor*(1.-result.a)+result*result.a;
        }
    }
}

void main()
{
    vec4 coordinate=vec4(textureCoordinate, 0., 1.);
    coordinate= mBlendMatrix * coordinate;
    vec4 srcColor=vec4(0., 0., 0., 0.);
    if (coordinate.x>=0.&&coordinate.x<=1.&&coordinate.y>=0.&&coordinate.y<=1.){
        srcColor=texture2D(inputImageTexture, coordinate.xy);
    }

    vec4 mBgColor = vec4(.0);
    if (mBgType == 0){
        mBgColor = srcColor;
    } else if (mBgType == 2){
        mBgColor=drawGradientBg();
    } else if (mBgType == 4){
        vec4 bgCoordinate=vec4(textureCoordinate2, 0., 1.);
        bgCoordinate= mBgMatrix * bgCoordinate;
        if (bgCoordinate.x>=0.&&bgCoordinate.x<=1.&&bgCoordinate.y>=0.&&bgCoordinate.y<=1.){
            mBgColor=texture2D(inputImageTexture2, bgCoordinate.xy);
        }
    }
    vec3 resultColor = mBgColor.rgb* (1.0 - srcColor.a) + srcColor.rgb;
    gl_FragColor= vec4(resultColor, mBgColor.a * (1.0 - srcColor.a) + srcColor.a);
}