////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform mat4 mBlendMatrix;
uniform int mCutoutType;
uniform int mEdgeOptimizationLevel;
uniform vec2 inputSize;// 纹理尺寸 (宽度，高度)
uniform int enableSmoothEdge;

vec4 getShowColorWithTranslucenta(vec4 srcColor, vec4 maskColor) {
    vec4 translucentaColor = vec4(0, 0, 0, 1.0);
    vec4 blendColor = translucentaColor * (1.0 - maskColor.a) * 0.5;
    return srcColor * (1.0 - blendColor.a) + blendColor;
}

void main()
{
    vec2 step = vec2(1.0) / inputSize;// 纹理步长，一个像素在纹理坐标系中的大小

    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 coordinate = vec4(textureCoordinate2, 0., 1.);
    coordinate = mBlendMatrix * coordinate;
    vec4 maskColor = texture2D(inputImageTexture2, coordinate.xy);
    if (mCutoutType == 1 && (coordinate.x < 0.0 || coordinate.x > 1.0 || coordinate.y < 0.0 || coordinate.y > 1.0)) {
        gl_FragColor = srcColor;
        return;
    }
    if (mCutoutType == 2) {
        // shape 裁剪+预览
        gl_FragColor = getShowColorWithTranslucenta(srcColor, maskColor);
    } else if (mCutoutType == 3) {
        // 当前的透明度效果
        vec4 translucenta = vec4(srcColor.rgb * 0.6 + (1. - srcColor.rgb) * 0.3, 0.85);
        // 计算混合因子
        float mixFactor = (1. - maskColor.a) * srcColor.a;
        // 混合源颜色和透明颜色
        gl_FragColor = srcColor * maskColor.a + translucenta * mixFactor;
    } else if (mCutoutType == 4 || mCutoutType == 1) {
        float minNeighborVal = maskColor.a;// 初始化为可能的最大灰度值或alpha值
        if (enableSmoothEdge == 1) {
            gl_FragColor = srcColor * minNeighborVal;
            return;
        }
        for (int i = -mEdgeOptimizationLevel; i <= mEdgeOptimizationLevel; ++i) {
            for (int j = -mEdgeOptimizationLevel; j <= mEdgeOptimizationLevel; ++j) {
                // 计算当前邻居的纹理坐标
                vec2 neighborCoord = coordinate.xy + vec2(float(i), float(j)) * step;
                // 取得当前邻居的灰度值
                float neighborVal = texture2D(inputImageTexture2, neighborCoord).a;
                // 更新最小灰度值
                minNeighborVal = min(minNeighborVal, neighborVal);
            }
        }
        gl_FragColor = srcColor * minNeighborVal;
    } else if (mCutoutType == 5 || mCutoutType == 7) {
        float minNeighborVal = maskColor.r;// 初始化为可能的最大灰度值或alpha值
        if (enableSmoothEdge == 1) {
            gl_FragColor = srcColor * minNeighborVal;
            return;
        }
        for (int i = -mEdgeOptimizationLevel; i <= mEdgeOptimizationLevel; ++i) {
            for (int j = -mEdgeOptimizationLevel; j <= mEdgeOptimizationLevel; ++j) {
                // 计算当前邻居的纹理坐标
                vec2 neighborCoord = coordinate.xy + vec2(float(i), float(j)) * step;
                // 取得当前邻居的灰度值
                float neighborVal = texture2D(inputImageTexture2, neighborCoord).r;
                // 更新最小灰度值
                minNeighborVal = min(minNeighborVal, neighborVal);
            }
        }
        gl_FragColor = srcColor * minNeighborVal;
    } else if (mCutoutType == 6) {
        vec4 translucenta = vec4(srcColor.rgb * 0.6 + (1. - srcColor.rgb) * 0.3, 0.85);
        gl_FragColor = srcColor * maskColor.r + translucenta * (1. - maskColor.r) * srcColor.a;
    } else {
        gl_FragColor = srcColor;
    }
}