////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
varying highp vec2 textureCoordinate3;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;

void main()
{
    highp vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    highp vec4 mixMaskColor = texture2D(inputImageTexture2, textureCoordinate);
    highp vec4 outColor = texture2D(inputImageTexture3, textureCoordinate);

    if (baseColor.a == 0.0) {
        gl_FragColor = baseColor;
        return;
    }

    // 根据条件判断设置mask
    float mask = 0.;
    if (mixMaskColor.r > 129. / 255.) {
        mask = 1.0;
    }
    if (mixMaskColor.r < 127. / 255.) {
        mask = 1.0;
    }

    float mixa = mask * mixMaskColor.a;

    // 应用mask到输出颜色
    //    vec4 finalColor  = vec4((baseColor * (1.0 - mixMaskColor.a) + outColor * mixMaskColor.a).rgb, 1.0);
    vec4 finalColor = vec4((baseColor * (1.0 - mixa) + outColor * mixa).rgb, baseColor.a);

    // 确保各通道不会变为负值
    finalColor.rgb = clamp(finalColor.rgb, 0.0, 1.0);

    // 输出最终颜色
    gl_FragColor = finalColor;
}