precision mediump float;
varying vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform mat4 maskMatrix;

uniform int drawType;
uniform float showRatio;

vec4 getAlphaColor(vec2 xy){
    float xCount=80.;
    float yCount=80.;
    float ratio=showRatio>0.?showRatio:1.;

    if (ratio>1.){
        yCount=xCount/ratio;
    } else {
        xCount=yCount*ratio;
    }
    float xPosition=floor(xy.x*xCount);
    float yPosition=floor(xy.y*yCount);
    if (mod(xPosition+yPosition, 2.)>.1){
        return vec4(1.);
    } else {
        return vec4(.75, .75, .75, 1.);
    }
}

vec4 getShowColorWithAlpha(vec4 srcColor, vec4 maskColor){
    vec4 bg=getAlphaColor(textureCoordinate);
    if (maskColor.a==0.){
        return srcColor*srcColor.a+bg*(1.-srcColor.a);
    } else if (maskColor.a==1.){
        return bg;
    } else {
        if (srcColor.a==0.){
            return bg;
        } else if (srcColor.a==1.){
            vec3 result=srcColor.rgb*(1.-maskColor.a)+bg.rgb*maskColor.a;
            return vec4(result, 1.);
        } else {
            vec4 result=srcColor*(1.-maskColor.a*srcColor.a)+bg*maskColor.a*srcColor.a;
            return bg*(1.-result.a)+result*result.a;
        }
    }
}



vec4 getShowColorWithTranslucenta(vec4 srcColor, vec4 maskColor) {
    vec4 bg = getAlphaColor(textureCoordinate);
    vec4 translucentaColor = vec4(0, 0, 0, 0.5);

    float mixFactor;
    vec4 result;

    if (maskColor.a == 0.) {
        mixFactor = 1. - srcColor.a;
        result = srcColor * srcColor.a + bg * mixFactor;
    } else if (maskColor.a == 1.) {
        mixFactor = 1. - srcColor.a;
        vec4 tmpResult = bg * mixFactor + srcColor;
        result = tmpResult * translucentaColor.a + translucentaColor;
    } else {
        vec4 maskedColor = maskColor * translucentaColor.a;

        if (srcColor.a == 0.) {
            result = bg;
        } else if (srcColor.a == 1.) {
            mixFactor = 1. - maskedColor.a;
            vec3 tmpResult = srcColor.rgb * mixFactor + translucentaColor.rgb * maskedColor.a;
            result = vec4(tmpResult, 1.);
        } else {
            mixFactor = 1. - maskedColor.a * srcColor.a;
            vec4 tmpResult = srcColor * mixFactor + maskedColor * srcColor.a;
            float finalMixFactor = 1. - tmpResult.a;
            result = bg * finalMixFactor + tmpResult * tmpResult.a;
        }
    }

    return result;
}


vec4 getSaveColor(vec4 srcColor, vec4 maskColor){
    if (maskColor.a==0.){
        return srcColor;
    } else if (maskColor.a==1.){
        return vec4(0);
    } else {
        return srcColor*(1.-maskColor.a);
    }
}

vec4 getLoadingColor(vec4 srcColor){
    if (srcColor.a==0.){
        return getAlphaColor(textureCoordinate);
    } else if (srcColor.a==1.){
        return srcColor;
    } else {
        vec3 result=srcColor.rgb*srcColor.a+getAlphaColor(textureCoordinate).rgb*(1.-srcColor.a);
        return vec4(result, srcColor.a);
    }
}

void main()
{
    vec4 srcColor=texture2D(inputImageTexture, textureCoordinate);
    if (drawType==0){
        gl_FragColor=getLoadingColor(srcColor);
        return;
    }
    vec4 maskCoor=vec4(textureCoordinate, 0., 1.);
    maskCoor=maskMatrix*maskCoor;
    vec4 maskColor=texture2D(inputImageTexture2, maskCoor.xy);
    if (drawType == 4){
        // 当前的透明度效果
        vec4 translucenta = vec4(srcColor.rgb * 0.6 + (1. - srcColor.rgb) * 0.3, 0.85);
        // 计算混合因子
        float mixFactor = maskColor.a * srcColor.a;
        // 混合源颜色和透明颜色
        vec4 result = srcColor * (1.-maskColor.a) + translucenta * mixFactor;
        // 颜色矩阵
        vec4 backgroundColor = getAlphaColor(textureCoordinate);
        // 叠加颜色
        gl_FragColor = mix(backgroundColor, result, result.a);
    } else if (drawType==3){
        gl_FragColor=getShowColorWithTranslucenta(srcColor, maskColor);
    } else if (drawType==2){
        gl_FragColor=getSaveColor(srcColor, maskColor);
    } else {
        gl_FragColor=getShowColorWithAlpha(srcColor, maskColor);
    }
}