////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;
varying highp vec2 textureCoordinate3;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;



void main()
{
    highp vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    highp vec4 garyColor = texture2D(inputImageTexture2, textureCoordinate);
    highp vec4 outColor = texture2D(inputImageTexture3, textureCoordinate);

    // 根据条件判断设置mask
    float mask = 0.;
    if (garyColor.a > 129. / 255.) {
        mask = 1.0;
    }
    if (garyColor.a < 127. / 255.) {
        mask = 1.0;
    }

    // 应用mask到输出颜色(存在负值)
    if (mask < 0.1) {
        gl_FragColor = vec4(0);
    } else {
        gl_FragColor = vec4(vec3(baseColor.rgb - outColor.rgb), baseColor.a);
    }



}