////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;  // 已经裁剪的纹理

uniform sampler2D inputImageTexture2;  // 已经裁剪的纹理
uniform mat4 mBlendMatrix;
uniform int useSecondTexture;
uniform int freeMode;
uniform float freeModeData[4];  // [左, 上, 右, 下]

vec4 getTextureColor(vec2 texCoord) {
    // 对在可视区域内的坐标应用变换
    vec4 coordinate = vec4(texCoord, 0.0, 1.0);
    coordinate = mBlendMatrix * coordinate;

    // 检查变换后的坐标是否在有效范围内
    if (coordinate.x < 0.0 || coordinate.x > 1.0 || coordinate.y < 0.0 || coordinate.y > 1.0) {
        return vec4(0.0, 0.0, 0.0, 0.0);
    }

    // 根据条件直接使用相应的采样器
    if (useSecondTexture == 1) {
        return texture2D(inputImageTexture2, coordinate.xy);
    } else {
        return texture2D(inputImageTexture, coordinate.xy);
    }
}

void main()
{
    // 选择使用哪个纹理坐标
    highp vec2 texCoord = textureCoordinate;
    vec4 coordinate = vec4(texCoord, 0.0, 1.0);
    // 自由模式的边界检查逻辑
    if (freeMode == 1) {
        if (coordinate.x > freeModeData[0] && coordinate.x < freeModeData[2]) {
            if (coordinate.y > (1.0 - freeModeData[3]) && coordinate.y < (1.0 - freeModeData[1])) {
                gl_FragColor = getTextureColor(texCoord);
                return;
            }
        }
        gl_FragColor = vec4(0.14, 0.14, 0.14, 1.0);
    } else {
        gl_FragColor = getTextureColor(texCoord);
    }

}