////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform float intensity;
const mediump vec3 luminanceWeighting = vec3(0.2126, 0.7152, 0.0722);

vec3 rgb2hsv(vec3 color)
{
    vec3 hsl;
    float fmin = min(min(color.r, color.g), color.b);
    float fmax = max(max(color.r, color.g), color.b);
    float delta = fmax - fmin;
    hsl.z = (fmax + fmin) / 2.0;
    if (delta == 0.0) {
        hsl.x = 0.0;
        hsl.y = 0.0;
    } else {
        if (hsl.z < 0.5) {
            hsl.y = delta / (fmax + fmin);
        } else {
            hsl.y = delta / (2.0 - fmax - fmin);
        }
        float deltaR = (((fmax - color.r) / 6.0) + (delta / 2.0)) / delta;
        float deltaG = (((fmax - color.g) / 6.0) + (delta / 2.0)) / delta;
        float deltaB = (((fmax - color.b) / 6.0) + (delta / 2.0)) / delta;
        if (color.r == fmax) {
            hsl.x = deltaB - deltaG;
        } else if (color.g == fmax) {
            hsl.x = (1.0 / 3.0) + deltaR - deltaB;
        } else if (color.b == fmax) {
            hsl.x = (2.0 / 3.0) + deltaG - deltaR;
        }
        if (hsl.x < 0.0) {
            hsl.x += 1.0;
        } else if (hsl.x > 1.0) {
            hsl.x -= 1.0;
        }
    }
    return hsl;
}


vec3 hsv2rgb(vec3 hsl)
{
    if (hsl.y == 0.0) {
        return vec3(hsl.z);
    } else {
        float f2;
        if (hsl.z < 0.5) {
            f2 = hsl.z * (1.0 + hsl.y);
        } else {
            f2 = (hsl.z + hsl.y) - (hsl.y * hsl.z);
        }
        float f1 = 2.0 * hsl.z - f2;
        float r;
        float g;
        float b;
        float hue1 = hsl.x + (1.0 / 3.0);
        if (hue1 < 0.0) {
            hue1 = hue1 + 1.0;
        } else if (hue1 > 1.0) {
            hue1 = hue1 - 1.0;
        }
        if ((6.0 * hue1) < 1.0) {
            r = f1 + (f2 - f1) * 6.0 * hue1;
        } else if ((2.0 * hue1) < 1.0) {
            r = f2;
        } else if ((3.0 * hue1) < 2.0) {
            r = f1 + (f2 - f1) * ((2.0 / 3.0) - hue1) * 6.0;
        } else {
            r = f1;
        }

        float hue2 = hsl.x;
        if (hue2 < 0.0) {
            hue2 = hue2 + 1.0;
        } else if (hue2 > 1.0) {
            hue2 = hue2 - 1.0;
        }
        if ((6.0 * hue2) < 1.0) {
            g = f1 + (f2 - f1) * 6.0 * hue2;
        } else if ((2.0 * hue2) < 1.0) {
            g = f2;
        } else if ((3.0 * hue2) < 2.0) {
            g = f1 + (f2 - f1) * ((2.0 / 3.0) - hue2) * 6.0;
        } else {
            g = f1;
        }

        float hue3 = hsl.x - (1.0 / 3.0);
        if (hue3 < 0.0) {
            hue3 = hue3 + 1.0;
        } else if (hue3 > 1.0) {
            hue3 = hue3 - 1.0;
        }
        if ((6.0 * hue3) < 1.0) {
            b = f1 + (f2 - f1) * 6.0 * hue3;
        } else if ((2.0 * hue3) < 1.0) {
            b = f2;
        } else if ((3.0 * hue3) < 2.0) {
            b = f1 + (f2 - f1) * ((2.0 / 3.0) - hue3) * 6.0;
        } else {
            b = f1;
        }
        return vec3(r, g, b);
    }
}


vec3 smoothTreatmentL(vec3 hsv, float min, float middle, float max, float shiftEdge0)
{
    float f = hsv.x > middle ? (middle - hsv.x) / (max - middle) : (middle - hsv.x) / (middle - min);
    float shiftZ = hsv.z > 0.5 ? (hsv.z - 0.5) / 0.5 : (0.5 - hsv.z) / 0.5;
    float shift = (1.0 - shiftZ) * (1.0 - shiftZ) * (shiftEdge0 - 1.0) * (5.0 - hsv.y * 3.) * hsv.y;
    float lumOffset = (1.0 - f * f) * shift + 1.0;
    float lum = clamp(hsv.z * lumOffset, 0., 1.);
    return vec3(hsv.x, hsv.y, lum);
}

vec3 smoothTreatmentS(vec3 rgb, float saturation, float start, float middle0, float middle1, float end, float location)
{
    float f;
    float satOffset;
    if (location < middle0) {
        f = (middle0 - location) / (middle0 - start);
        satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f * f : saturation + (1.0 - saturation) * f * f;
    } else if (location > middle1) { ;
                                     f = (location - middle1) / (end - middle1);
                                     satOffset = saturation > 1.0 ? saturation - (saturation - 1.0) * f : saturation + (1.0 - saturation) * f;
    } else {
        satOffset = saturation;
    }
    float luminance = dot(rgb, luminanceWeighting);
    vec3 greyScaleColor = vec3(luminance);
    return vec3(mix(greyScaleColor, rgb, satOffset));
}


void main()
{
    highp vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    vec3 parseHsl = rgb2hsv(baseColor.rgb);

    ////        baseColor.rgb = smoothTreatmentS(baseColor.rgb,(intensity -1.0)/2.0 + 1.0, 0.0, 0.078,  0.08, 0.125, parseHsl.x);
    ////        parseHsl = rgb2hsv(baseColor.rgb);
    //        parseHsl = smoothTreatmentL(parseHsl, 0.0, 0.08, 0.125, (intensity -1.0)/2.0 + 1.0 );
    //        baseColor.rgb = hsv2rgb(parseHsl);
    float offset = 1.0 - length(textureCoordinate - 0.5) / sqrt(0.5);
    vec3 result = vec3(0);
    float mag = intensity * 1.045 * baseColor.a * offset;
    float exppower = 1.0 + abs(mag);
    result.r = 1.0 - pow((1.0 - baseColor.r), exppower);
    result.g = 1.0 - pow((1.0 - baseColor.g), exppower);
    result.b = 1.0 - pow((1.0 - baseColor.b), exppower);
    // 输出最终颜色
    gl_FragColor = vec4(result, baseColor.a);


}