////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform float intensity;



void main()
{
    highp vec4 inputColor = texture2D(inputImageTexture, textureCoordinate);
    highp vec4 effectColor = texture2D(inputImageTexture2, textureCoordinate);

    // 根据条件判断设置mask
    vec3 finalRGB = inputColor.rgb + effectColor.rgb * intensity;
    //    vec3 finalRGB   = inputColor.rgb + effectColor.rgb * intensity;
    finalRGB = clamp(finalRGB, 0.0, 1.0);
    // 输出最终颜色
    gl_FragColor = vec4(finalRGB, inputColor.a);
}