#version 300 es
#extension GL_OES_texture_3D : enable
precision highp float;
in highp vec2 textureCoordinate;
in highp vec2 textureCoordinate2;
in highp vec2 textureCoordinate3;
in highp vec2 textureCoordinate4;

uniform sampler2D inputImageTexture;
uniform highp sampler3D inputImageTexture2;
uniform highp sampler3D inputImageTexture3;
uniform highp sampler3D inputImageTexture4;

uniform float w1;
uniform float w2;
uniform float w3;
uniform float intensity;
out vec4 FragColor;

void main()
{
    float dimension = 33.0;

    vec4 color = texture(inputImageTexture, textureCoordinate.xy);
    vec3 dim = ((color.rgb * (dimension - 1.0) + 0.5))/dimension;

    vec4 destColor2 = texture(inputImageTexture2, dim);
    vec4 destColor3 = texture(inputImageTexture3, dim);
    vec4 destColor4 = texture(inputImageTexture4, dim);

    vec4 destColor = vec4(1.0);
    destColor.rgb = destColor2.rgb*w1 + destColor3.rgb*w2 + destColor4.rgb*w3;

    //vec3 coor = vec3(color.r, color.g, color.b);
    //destColor2 = texture3D(inputImageTexture2, coor);
    FragColor = vec4(mix(color.rgb, destColor.rgb, intensity), color.a);
}