attribute vec4 a_vertex; // (center, entropy)
attribute vec4 a_uv; // (uv, offsetXY)

uniform mat4 u_projMat;
uniform float u_time;
uniform vec3 u_offset; // snowDir
uniform vec2 u_settings; // (turbulence, gradient)

varying vec2 coord;
varying float alpha;

void main()
{
    coord = a_uv.xy;
    vec3 center = u_time * u_offset + a_vertex.xyz;
    float sway = u_settings.x * a_vertex.w * sin(2. * mod(a_vertex.w, .5) * u_time + 4. * mod(a_vertex.w, .25));
    center.x += sway;
    if(u_offset.z != 0.)
        center.y += sway * 2. * 8. * mod(a_vertex.w, .125);
    center = mod(center + 1., 2.) - 1.;
    float scale = .33 + .67 * 8. * mod(a_vertex.w, .125);
    float gradient = 1.;
    float limit = gradient * (.8 + .5 * center.y);
    if(u_settings.y < .001)
        limit = 1.;
    alpha = smoothstep(-limit, -limit + .05, center.z);
    gl_Position = u_projMat * vec4(scale * a_uv.zw + center.xy, center.z, 1.);
}