const mat3 sRGBd50 =    mat3(   0.436075,   0.222504,   0.013932,
                                0.385065,   0.716879,   0.097104,
                                0.143080,   0.060617,   0.714173 );

const mat3 sRGBd50inv = mat3(   3.133856,  -0.978768,   0.071945,
                                -1.616867,   1.916141,  -0.228991,
                                -0.490615,   0.033454,   1.405243 );

const mat3 PP =         mat3(   0.79767,    0.28804,    0.00000,
                                0.13519,    0.71187,    0.00000,
                                0.03135,    0.00009,    0.82521 );

const mat3 PPinv =      mat3(   1.34594,   -0.54460,    0.00000,
                                -0.25561,    1.50817,    0.00000,
                                -0.05111,    0.02054,    1.21181 );

const vec3 grayCol = vec3(.30, .59, .11);

vec4 gamma24(const in vec4 a)
{
    return vec4(
        a.r <= .04045 ? a.r / 12.92 : pow((a.r + .055) / 1.055, 2.4),
        a.g <= .04045 ? a.g / 12.92 : pow((a.g + .055) / 1.055, 2.4),
        a.b <= .04045 ? a.b / 12.92 : pow((a.b + .055) / 1.055, 2.4),
        a.a <= .04045 ? a.a / 12.92 : pow((a.a + .055) / 1.055, 2.4)
    );
}

vec4 gamma24inv(const in vec4 a)
{
    return vec4(
        a.r <= .003131 ? a.r * 12.92 : 1.055 * pow(a.r, 1. / 2.4) - .055,
        a.g <= .003131 ? a.g * 12.92 : 1.055 * pow(a.g, 1. / 2.4) - .055,
        a.b <= .003131 ? a.b * 12.92 : 1.055 * pow(a.b, 1. / 2.4) - .055,
        a.a <= .003131 ? a.a * 12.92 : 1.055 * pow(a.a, 1. / 2.4) - .055
    );
}

vec3 gamma24(const in vec3 a)
{
    return vec3(
        a.r <= .04045 ? a.r / 12.92 : pow((a.r + .055) / 1.055, 2.4),
        a.g <= .04045 ? a.g / 12.92 : pow((a.g + .055) / 1.055, 2.4),
        a.b <= .04045 ? a.b / 12.92 : pow((a.b + .055) / 1.055, 2.4)
    );
}

vec3 gamma24inv(const in vec3 a)
{
    return vec3(
        a.r <= .003131 ? a.r * 12.92 : 1.055 * pow(a.r, 1. / 2.4) - .055,
        a.g <= .003131 ? a.g * 12.92 : 1.055 * pow(a.g, 1. / 2.4) - .055,
        a.b <= .003131 ? a.b * 12.92 : 1.055 * pow(a.b, 1. / 2.4) - .055
    );
}

vec2 gamma24(const in vec2 a)
{
    return vec2(
        a.r <= .04045 ? a.r / 12.92 : pow((a.r + .055) / 1.055, 2.4),
        a.g <= .04045 ? a.g / 12.92 : pow((a.g + .055) / 1.055, 2.4)
    );
}

// f in [-16, 16]
const float pack_shift = 16.;
const float pack_scale = 32.;

vec4 pack_float(const in float v)
{
    float g = (v + pack_shift) / pack_scale;
    vec4 enc = vec4(1., 255., 65025., 16581375.) * g;
    enc = fract(enc);
    enc -= enc.yzww * vec4(1./255., 1./255., 1./255., 0.);
    return enc;
}
float unpack_float(const in vec4 rgba)
{
    float g = dot( rgba, vec4(1., 1./255., 1./65025., 1./16581375.) );
    return g * pack_scale - pack_shift;
}

float k0, k1, k2, k3, k4, k5, k6, k7, k8, k9, k10, k11, k12;
float k13, k14, k15, k16, k17, k18, k19, k20, k21, k22, k23, k24;


float get_value(sampler2D tex, vec2 coord) {
    float ret;
#ifdef EXT_color_buffer_float
    ret = texture2D(tex, coord).r;
#else
    ret = unpack_float(texture2D(tex, coord));
#endif
    return ret;
}

void write(inout vec4 color, float g) {
#ifdef EXT_color_buffer_float
    color.r = g;
#else
    color = pack_float(g);
#endif
}

float unpack_float16(vec2 rg) {
    return rg.r + (1./256.) * rg.g;
}

float get_value16(sampler2D tex, vec2 coord) {
    vec4 rgba = texture2D(tex, coord);
    return unpack_float16(rgba.rg);
}

vec2 pack_float16(float g) {
    vec2 rg = vec2(0.);

    rg.x = floor(255. * g) * (1./255.);
    rg.y = (g - rg.x) * 256.; // TODO: 255 or 256?

    return rg;
}

vec2 balance_packed16(vec2 rg) {
    return pack_float16(rg.x + (1./256.) * rg.y);
}

vec3 toneCurve(vec3 x, sampler2D curves, float curvesRes) {

    float r = get_value16(curves, vec2(.5 / curvesRes + (curvesRes - 1.) / curvesRes * x.r, .375));
    float g = get_value16(curves, vec2(.5 / curvesRes + (curvesRes - 1.) / curvesRes * x.g, .375));
    float b = get_value16(curves, vec2(.5 / curvesRes + (curvesRes - 1.) / curvesRes * x.b, .375));

    return vec3(r, g, b);
}

vec3 toneCurveInv(vec3 x, sampler2D curves, float curvesRes) {

    float r = get_value16(curves, vec2(.5 / curvesRes + (curvesRes - 1.) / curvesRes * x.r, .625));
    float g = get_value16(curves, vec2(.5 / curvesRes + (curvesRes - 1.) / curvesRes * x.g, .625));
    float b = get_value16(curves, vec2(.5 / curvesRes + (curvesRes - 1.) / curvesRes * x.b, .625));

    return vec3(r, g, b);
}

float getGaussianBlurred(sampler2D tex, vec2 coord, vec2 size) {
    float g = 0.;

    vec3 offset = vec3(1. / size, 0.);

    // TODO: Use vertical and horizontal blur as an optimization!
    k0 = get_value(tex, coord + vec2(-2, -2) * offset.xy);
    k1 = get_value(tex, coord + vec2(-2, -1) * offset.xy);
    k2 = get_value(tex, coord + vec2(-2, 0) * offset.xy);
    k3 = get_value(tex, coord + vec2(-2, 1) * offset.xy);
    k4 = get_value(tex, coord + vec2(-2, 2) * offset.xy);

    k5 = get_value(tex, coord + vec2(-1, -2) * offset.xy);
    k6 = get_value(tex, coord + vec2(-1, -1) * offset.xy);
    k7 = get_value(tex, coord + vec2(-1, 0) * offset.xy);
    k8 = get_value(tex, coord + vec2(-1, 1) * offset.xy);
    k9 = get_value(tex, coord + vec2(-1, 2) * offset.xy);

    k10 = get_value(tex, coord + vec2(0, -2) * offset.xy);
    k11 = get_value(tex, coord + vec2(0, -1) * offset.xy);
    k12 = get_value(tex, coord + vec2(0, 0) * offset.xy);
    k13 = get_value(tex, coord + vec2(0, 1) * offset.xy);
    k14 = get_value(tex, coord + vec2(0, 2) * offset.xy);

    k15 = get_value(tex, coord + vec2(1, -2) * offset.xy);
    k16 = get_value(tex, coord + vec2(1, -1) * offset.xy);
    k17 = get_value(tex, coord + vec2(1, 0) * offset.xy);
    k18 = get_value(tex, coord + vec2(1, 1) * offset.xy);
    k19 = get_value(tex, coord + vec2(1, 2) * offset.xy);

    k20 = get_value(tex, coord + vec2(2, -2) * offset.xy);
    k21 = get_value(tex, coord + vec2(2, -1) * offset.xy);
    k22 = get_value(tex, coord + vec2(2, 0) * offset.xy);
    k23 = get_value(tex, coord + vec2(2, 1) * offset.xy);
    k24 = get_value(tex, coord + vec2(2, 2) * offset.xy);

    g += 1. * k0 +  4. * k1 +  6. * k2 +  4. * k3 + 1. * k4;
    g += 4. * k5 + 16. * k6 + 24. * k7 + 16. * k8 + 4. * k9;
    g += 6. * k10 + 24. * k11 + 36. * k12 + 24. * k13 + 6. * k14;
    g += 4. * k15 + 16. * k16 + 24. * k17 + 16. * k18 + 4. * k19;
    g += 1. * k20 +  4. * k21 +  6. * k22 +  4. * k23 + 1. * k24;

    g *= 1./256.;

    return g;
}

float getExpanded(sampler2D tex, vec2 coord, vec2 size) {
    float g = 0.;

    vec3 offset = vec3(1. / size, 0.);

    // TODO: Use vertical and horizontal blur as an optimization!
    k0 = get_value(tex, coord + vec2(-2, -2) * offset.xy);
    k1 = get_value(tex, coord + vec2(-2, -1) * offset.xy);
    k2 = get_value(tex, coord + vec2(-2, 0) * offset.xy);
    k3 = get_value(tex, coord + vec2(-2, 1) * offset.xy);
    k4 = get_value(tex, coord + vec2(-2, 2) * offset.xy);

    k5 = get_value(tex, coord + vec2(-1, -2) * offset.xy);
    k6 = get_value(tex, coord + vec2(-1, -1) * offset.xy);
    k7 = get_value(tex, coord + vec2(-1, 0) * offset.xy);
    k8 = get_value(tex, coord + vec2(-1, 1) * offset.xy);
    k9 = get_value(tex, coord + vec2(-1, 2) * offset.xy);

    k10 = get_value(tex, coord + vec2(0, -2) * offset.xy);
    k11 = get_value(tex, coord + vec2(0, -1) * offset.xy);
    k12 = get_value(tex, coord + vec2(0, 0) * offset.xy);
    k13 = get_value(tex, coord + vec2(0, 1) * offset.xy);
    k14 = get_value(tex, coord + vec2(0, 2) * offset.xy);

    k15 = get_value(tex, coord + vec2(1, -2) * offset.xy);
    k16 = get_value(tex, coord + vec2(1, -1) * offset.xy);
    k17 = get_value(tex, coord + vec2(1, 0) * offset.xy);
    k18 = get_value(tex, coord + vec2(1, 1) * offset.xy);
    k19 = get_value(tex, coord + vec2(1, 2) * offset.xy);

    k20 = get_value(tex, coord + vec2(2, -2) * offset.xy);
    k21 = get_value(tex, coord + vec2(2, -1) * offset.xy);
    k22 = get_value(tex, coord + vec2(2, 0) * offset.xy);
    k23 = get_value(tex, coord + vec2(2, 1) * offset.xy);
    k24 = get_value(tex, coord + vec2(2, 2) * offset.xy);

    g += 1. * k0 +  4. * k1 +  6. * k2 +  4. * k3 + 1. * k4;
    g += 4. * k5 + 16. * k6 + 24. * k7 + 16. * k8 + 4. * k9;
    g += 6. * k10 + 24. * k11 + 36. * k12 + 24. * k13 + 6. * k14;
    g += 4. * k15 + 16. * k16 + 24. * k17 + 16. * k18 + 4. * k19;
    g += 1. * k20 +  4. * k21 +  6. * k22 +  4. * k23 + 1. * k24;

    g *= 1./256.;

    return g;
}

// 1D Gaussian kernel for 29x29
const float g0 = 1800.;
const float g1 = 1733.;
const float g2 = 1546.;
const float g3 = 1279.;
const float g4 = 981.;
const float g5 = 698.;
const float g6 = 460.;
const float g7 = 281.;
const float g8 = 159.;
const float g9 = 84.;
const float g10 = 41.;
const float g11 = 18.;
const float g12 = 8.;
const float g13 = 3.;
const float g14 = 1.;
const float gNorm = 1. / 16384.;

vec4 getPlainGaussianBlurred1D(sampler2D tex, vec2 coord, vec2 size, vec2 xyDir) {

    vec4 col = g0 * texture2D(tex, coord);

    vec2 offset = xyDir / size;

    col += g1 * (texture2D(tex, coord - 1. * offset)
              + texture2D(tex, coord + 1. * offset));
    col += g2 * (texture2D(tex, coord - 2. * offset)
              + texture2D(tex, coord + 2. * offset));
    col += g3 * (texture2D(tex, coord - 3. * offset)
              + texture2D(tex, coord + 3. * offset));
    col += g4 * (texture2D(tex, coord - 4. * offset)
              + texture2D(tex, coord + 4. * offset));
    col += g5 * (texture2D(tex, coord - 5. * offset)
              + texture2D(tex, coord + 5. * offset));
    col += g6 * (texture2D(tex, coord - 6. * offset)
              + texture2D(tex, coord + 6. * offset));
    col += g7 * (texture2D(tex, coord - 7. * offset)
              + texture2D(tex, coord + 7. * offset));
    col += g8 * (texture2D(tex, coord - 8. * offset)
              + texture2D(tex, coord + 8. * offset));
    col += g9 * (texture2D(tex, coord - 9. * offset)
              + texture2D(tex, coord + 9. * offset));
    col += g10 * (texture2D(tex, coord - 10. * offset)
               + texture2D(tex, coord + 10. * offset));
    col += g11 * (texture2D(tex, coord - 11. * offset)
               + texture2D(tex, coord + 11. * offset));
    col += g12 * (texture2D(tex, coord - 12. * offset)
               + texture2D(tex, coord + 12. * offset));
    col += g13 * (texture2D(tex, coord - 13. * offset)
               + texture2D(tex, coord + 13. * offset));
    col += g14 * (texture2D(tex, coord - 14. * offset)
               + texture2D(tex, coord + 14. * offset));

    col *= gNorm;

    return col;
}

vec3 colorspace(vec3 rgb, sampler2D curves, float curvesRes) {
    rgb = gamma24(rgb);
    rgb = sRGBd50 * rgb;
    rgb = PPinv * rgb;
    rgb = clamp(rgb, 0., 1.);

    rgb = toneCurve(rgb, curves, curvesRes); // Tone curve might be unused here // TODO: check

    return rgb;
}

vec3 colorspaceInv(vec3 rgb, sampler2D curves, float curvesRes) {
    rgb = clamp(rgb, 0., 1.);
    rgb = toneCurveInv(rgb, curves, curvesRes);

    rgb = clamp(rgb, 0., 1.);
    rgb = PP * rgb;
    rgb = sRGBd50inv * rgb;
    rgb = gamma24inv(rgb);

    return rgb;
}