#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_curves;
uniform float u_curvesRes;

varying vec2 coord;

#include utils

void main()
{
    vec3 rgb = texture2D(u_tex, coord).rgb;
    rgb = colorspace(rgb, u_curves,  u_curvesRes);

    vec3 toned = log(rgb * 100. + 1.) * 0.216679065; // TODO: log2?

    float y = .25 * toned.r + .75 * toned.g;
    float c0 = (-.75 * toned.r + .75 * toned.g) *.5 + .5;
    float c1 = (.25 * toned.r + .75 * toned.g - toned.b) *.5 + .5;

    gl_FragColor = vec4(y, c0, c1, 1.); // TODO: Is 8 bit output enough here?
}