#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_tex2;
uniform sampler2D u_tex3;
uniform float u_alpha;
uniform sampler2D u_curves;
uniform float u_curvesRes;

varying vec2 coord;

#include utils

void main()
{
    vec3 ycc = texture2D(u_tex, coord).rgb;
    vec3 a = texture2D(u_tex2, coord).rgb;
    vec3 b = texture2D(u_tex3, coord).rgb;

    vec3 guided = b + ycc.x * a;
    guided = clamp(guided, 0., 1.);

    // Inverse transform
    vec3 rgb = vec3(0.);

    rgb.r = ycc.x - 2. * (ycc.y - .5);
    rgb.b = ycc.x - 2. * (ycc.z - .5);
    rgb.g = (ycc.x - rgb.r * .25) * 1.3333;

    vec3 g_rgb = vec3(0.);

    g_rgb.r = guided.x - 2. * (guided.y - .5);
    g_rgb.b = guided.x - 2. * (guided.z - .5);
    g_rgb.g = (guided.x - g_rgb.r * .25) * 1.3333;

    float strength = u_alpha;
    if(u_alpha < 0.)
        strength *= .67;
    rgb = mix(rgb, g_rgb, -strength);

    rgb = (exp(rgb * 4.615120517) - 1.) * .01;

    rgb = colorspaceInv(rgb, u_curves,  u_curvesRes);

    gl_FragColor = vec4(rgb, 1.);
}