#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_tex2;

varying vec2 coord;

const vec3 e = vec3(1./320.);

void main()
{
    vec3 mean = texture2D(u_tex, coord).rgb;
    vec3 corr = texture2D(u_tex2, coord).rgb;

    vec3 cov = corr - mean.x * mean;

    gl_FragColor = vec4(cov / (cov.x + e), 1.);
}