#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float; // TODO: mediump might be enough
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_curves;
uniform float u_curvesRes;
uniform float u_alpha;

varying vec2 coord;

#include utils

vec3 RGBToHminmax(vec3 color)
{
    float fmin = min(min(color.r, color.g), color.b);
    float fmax = max(max(color.r, color.g), color.b);
    float chroma = fmax - fmin;

    vec3 hsl = vec3(0., fmin, fmax);

    if (chroma != 0.0)
    {
        vec3 delta = - color / 6. / chroma;

        if (color.r == fmax )
            hsl.x = delta.b - delta.g;
        else if (color.g == fmax)
            hsl.x = (1.0 / 3.0) + delta.r - delta.b;
        else if (color.b == fmax)
            hsl.x = (2.0 / 3.0) + delta.g - delta.r;

        hsl.x = fract(hsl.x);
    }

    return hsl;
}

float HueToRGB(float fmin, float fmax, float hue)
{
    hue = fract(hue);

    float res;
    if ((6.0 * hue) < 1.0)
        res = fmin + (fmax - fmin) * 6.0 * hue;
    else if ((2.0 * hue) < 1.0)
        res = fmax;
    else if ((3.0 * hue) < 2.0)
        res = fmin + (fmax - fmin) * ((2.0 / 3.0) - hue) * 6.0;
    else
        res = fmin;

    return res;
}

vec3 HminmaxToRGB(vec3 hsl)
{
    vec3 rgb = vec3(0.);

    float fmin = hsl.y;
    float fmax = hsl.z;

    rgb.r = HueToRGB(fmin, fmax, hsl.x + (1.0/3.0));
    rgb.g = HueToRGB(fmin, fmax, hsl.x);
    rgb.b = HueToRGB(fmin, fmax, hsl.x - (1.0/3.0));

    return rgb;
}

void vibrance(inout vec3 a,in sampler2D curves)
{
	vec3 c = RGBToHminmax(a);
	float hue = c.x;
    float fmin = c.y;
    float fmax = c.z;
	float chroma = fmax - fmin;

    if(fmax <= 0. || u_alpha == 0.)
        return;

    float normChroma = chroma / fmax;
    float chromaFactor = normChroma - normChroma * normChroma;

    float darkFactor = min(16. * fmax, 1.);
    darkFactor = 2. * darkFactor - darkFactor * darkFactor;

    float strength = 0.;
    if(u_alpha > 0.) {
        hue /= 60.;
        float hueFactor = clamp(min(hue, 7. - 4. * hue), 0., 1.);

        strength = .25 * u_alpha * ((u_alpha - 1.) * hueFactor * chromaFactor + 1.);

        normChroma /= 1. + (1.6190 * hueFactor * chromaFactor - 3.3333) * strength * (1. - fmin) * darkFactor * (1. - normChroma);
    }
    else {
        strength = u_alpha;

        normChroma *= (1. + .25 * strength) * ((1. + strength) - .5 * strength * (1. + normChroma) * darkFactor);
    }

    fmax *= 1. + strength * (2. - chromaFactor) * chromaFactor * darkFactor * (1. - fmax);
    fmin = fmax - normChroma * fmax;

    c.y = fmin;
    c.z = fmax;

	a = HminmaxToRGB(c);
}

void main()
{
    vec3 rgb = texture2D(u_tex, coord).rgb;

    rgb = colorspace(rgb, u_curves, u_curvesRes);

    vibrance(rgb, u_curves);

    rgb = colorspaceInv(rgb, u_curves, u_curvesRes);

    gl_FragColor = vec4(rgb, 1.);
}
