precision mediump float;

uniform sampler2D u_tex;
uniform float u_alpha;

uniform vec4 u_clip;

varying vec2 coord;
varying float alpha;

void main()
{
    vec4 col = texture2D(u_tex, coord);
    if(u_alpha > 0.) {
        gl_FragColor = alpha * u_alpha * col;
    }
    else {
        float a = length(col.rgb);
        gl_FragColor = vec4(0., 0., 0., -alpha * u_alpha * .5 * a);
    }
}