precision mediump float;

uniform sampler2D u_tex;
uniform sampler2D u_tex2; // tone curves
uniform vec4 u_offset; // curvesRes;

varying vec2 coord;

#include utils

void main()
{
    vec4 col = texture2D(u_tex, coord);

    col.rgb = gamma24(col.rgb);
    col.rgb = sRGBd50 * col.rgb;
    col.rgb = PPinv * col.rgb;
    col.rgb = clamp(col.rgb, 0., 1.);

    // Fetch from curves
    vec3 cc = (u_offset.x - 1.) / u_offset.x * col.rgb + .5 / u_offset.x;
    col.r = texture2D(u_tex2, vec2(cc.r, .5)).r;
    col.g = texture2D(u_tex2, vec2(cc.g, .5)).g;
    col.b = texture2D(u_tex2, vec2(cc.b, .5)).b;

    col.rgb = clamp(col.rgb, 0., 1.);
    col.rgb = PP * col.rgb;
    col.rgb = sRGBd50inv * col.rgb;
    col.rgb = clamp(col.rgb, 0., 1.);
    col.rgb = gamma24inv(col.rgb);

    gl_FragColor = col;
}