precision mediump float;

uniform sampler2D u_tex;
uniform vec2 u_size; // Size of target texture

varying vec2 coord;


#include utils

// Unpacks and normalizes a packed gray log texture so that span can work on it
// Also performs first reduction pass

void main()
{
    vec2 offset = .25 / u_size;

    float a = get_value(u_tex, coord + vec2(-1, -1) * offset);
    float b = get_value(u_tex, coord + vec2(1, -1) * offset);
    float c = get_value(u_tex, coord + vec2(-1, 1) * offset);
    float d = get_value(u_tex, coord + vec2(1, 1) * offset);

    a = max(a, -11.);
    b = max(b, -11.);
    c = max(c, -11.);
    d = max(d, -11.);

    float lowest = min(min(a, b), min(c, d));
    float highest = max(max(a, b), max(c, d));
    float average = (a + b + c + d) / 4.;
    float lin = exp2(average) - 1./4096.;
    float gammaAverage = gamma24inv(vec4(lin)).r;

    vec3 rgb = vec3(lowest, highest, average);
    rgb = rgb * 1./12. + 1.;

    gl_FragColor = vec4(rgb, gammaAverage);
}