precision mediump float;

uniform sampler2D u_tex;
uniform vec2 u_size; // Size of target texture

varying vec2 coord;


// Gathers the max, min and average of a gray texture assuming the pixel covers 4 source pixels
// rgb = (lowest, highest, average, gammaAverage)

void main()
{
    vec2 offset = .25 / u_size;

    vec4 a = texture2D(u_tex, coord + vec2(-1, -1) * offset);
    vec4 b = texture2D(u_tex, coord + vec2(1, -1) * offset);
    vec4 c = texture2D(u_tex, coord + vec2(-1, 1) * offset);
    vec4 d = texture2D(u_tex, coord + vec2(1, 1) * offset);

    float lowest = min(min(a.r, b.r), min(c.r, d.r));
    float highest = max(max(a.g, b.g), max(c.g, d.g));
    vec2 averages = (a.ba + b.ba + c.ba + d.ba) / 4.;

    gl_FragColor = vec4(lowest, highest, averages);
}