precision mediump float;

uniform sampler2D u_tex;
uniform vec2 u_originalSize;
uniform float u_alpha;

varying vec2 coord;

void main()
{
    float strength = 10. * u_alpha;

    vec4 col = (1. + 4./9. * strength) * texture2D(u_tex, coord);

    vec3 offset = vec3(1. / u_originalSize, 0.);

    col -= 1./9. * strength * texture2D(u_tex, coord + offset.xz);
    col -= 1./9. * strength * texture2D(u_tex, coord - offset.xz);
    col -= 1./9. * strength * texture2D(u_tex, coord + offset.zy);
    col -= 1./9. * strength * texture2D(u_tex, coord - offset.zy);

    gl_FragColor = col;
}