precision mediump float;

uniform sampler2D u_tex;
varying vec2 coord;

void main()
{
    vec4 noise = vec4(0.);

    noise.x = texture2D(u_tex, coord * 8.).x; // small smooth

    noise.z = texture2D(u_tex, coord * 4.).y; // big smooth

    // small rough
    noise.y =         .25 * texture2D(u_tex, coord * 8.).x
                    + .25 * texture2D(u_tex, coord * 4.).y
                    + .25 * texture2D(u_tex, coord * 2.).z
                    + .25 * texture2D(u_tex, coord * 1.).x;

    // big rough
    noise.w =         .333 * texture2D(u_tex, coord * 4.).y
                    + .333 * texture2D(u_tex, coord * 2.).z
                    + .333 * texture2D(u_tex, coord * 1.).x;

    //noise = pow(noise + .5, 1.5) - .5;

    gl_FragColor = noise;
}