precision mediump float;

uniform sampler2D u_tex;
uniform mat4 u_colMat;
uniform vec4 u_colAdd;
uniform float u_alpha;

uniform vec4 u_clip;

varying vec2 coord;

void main()
{
    if(coord.x > u_clip.x && coord.x < u_clip.y
            && coord.y > u_clip.z && coord.y < u_clip.q)
        discard;

    vec4 col = u_colMat * texture2D(u_tex, coord) + u_colAdd;
    if(u_alpha > 0.) {
        gl_FragColor = u_alpha * col;
    }
    else {
        float a = length(col.rgb);
        gl_FragColor = vec4(0., 0., 0., -u_alpha * .5 * a);
    }
}