precision mediump float;

uniform sampler2D u_tex;
uniform sampler2D u_lut;
uniform float u_alpha;

varying vec2 coord;

void main()
{
    vec4 col = texture2D(u_tex, coord);
    col = clamp(col, 0., 1.);

    // Fetch from LUT
    vec2 lc = col.rg * vec2(15./256., 15./16.); // [0,15]/255 -> [0,1./17]
    lc += vec2(.5/256., .5/16.); // Account for pixel center
    float bi = floor(15.*col.b); // bi = [0,15]
    bi = clamp(bi, 0., 14.);
    float bd = 15. * (col.b - bi/15.); // bd = [0,1]
    vec2 lc2 = lc;
    lc.x += bi/16.;
    vec4 lutCol = texture2D(u_lut, lc);
    bi = clamp(bi + 1., 0., 15.);
    lc2.x += bi/16.;
    lutCol = mix(lutCol, texture2D(u_lut, lc2), bd);

    gl_FragColor = mix(col, lutCol, u_alpha);
}