precision mediump float;

varying vec2 coord;

#include utils

vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

void main()
{
    float sat = 2. * distance(coord, vec2(.5));

    float hue = atan(-coord.y + .5, coord.x - .5) / 2. / 3.1415926538;

    vec3 hsv = vec3(hue, max(-.05 + .9 * sat, 0.), 1.);
    vec3 rgb = hsv2rgb(hsv);

    rgb = gamma24(rgb);
    rgb = PP * rgb;
    rgb = sRGBd50inv * rgb;
    rgb = clamp(rgb, 0., 1.);
    rgb = gamma24inv(rgb);

    gl_FragColor = vec4(rgb, sat <= 1. ? 1. : 0.);
}