precision highp float;

uniform sampler2D u_tex;
uniform sampler2D u_grainTex;
uniform sampler2D u_grain2Tex;
uniform vec2 u_size;
uniform vec2 u_grainTexSize;

uniform vec4 u_grainInfo;
uniform float u_time;

varying vec2 coord;

const vec3 lumcoeff = vec3(0.299, 0.587, 0.114);

void main()
{
    vec4 col = texture2D(u_tex, coord);

    float alpha = u_grainInfo.x;
    float highlights = u_grainInfo.y;
    float grainSize = u_grainInfo.z;
    float roughness = u_grainInfo.w;

    vec2 c = coord;
    c.y = 1. - c.y;

    vec2 gcoord = (c.xy + sin(u_time * 4.5453)) * u_size / u_grainTexSize.xy;
    gcoord = fract(gcoord);

    vec4 entropy = texture2D(u_grainTex, gcoord);
    entropy.a = texture2D(u_grain2Tex, gcoord).r;
    // entropy = (small_smooth, small_rough, big_smooth, big_rough)
    float grain = mix(mix(entropy.r, entropy.b, grainSize), mix(entropy.g, entropy.a, grainSize), roughness);
    float lum = dot(lumcoeff, col.rgb);
    grain = mix(.5, grain, alpha * (1. - lum * highlights) * (1. - pow(1. - lum, 4.)));
    col.rgb += 2. * grain - 1.;

    gl_FragColor = col;
}