precision mediump float;

uniform sampler2D u_tex;
uniform vec2 u_size; // Size of target texture

varying vec2 coord;

const vec3 grayCol = vec3(.30, .59, .11);

void main()
{
    vec2 offset = .25 / u_size;

    // (rgb, darkChannel)
    vec4 a = texture2D(u_tex, coord + vec2(-1, -1) * offset);
    vec4 b = texture2D(u_tex, coord + vec2(1, -1) * offset);
    vec4 c = texture2D(u_tex, coord + vec2(-1, 1) * offset);
    vec4 d = texture2D(u_tex, coord + vec2(1, 1) * offset);

    float bright = max(max(a.a, b.a), max(c.a, d.a));

    vec4 col = vec4(0.);
    if(a.a == bright)
        col = a;
    else if(b.a == bright)
        col = b;
    else if(c.a == bright)
        col = c;
    else
        col = d;

    gl_FragColor = col;
}