precision mediump float;

uniform sampler2D u_tex;
uniform vec2 u_size; // Size of target texture

varying vec2 coord;

const vec3 grayCol = vec3(.30, .59, .11);

void main()
{
    vec2 offset = .25 / u_size;

    vec4 a = texture2D(u_tex, coord + vec2(-1, -1) * offset);
    vec4 b = texture2D(u_tex, coord + vec2(1, -1) * offset);
    vec4 c = texture2D(u_tex, coord + vec2(-1, 1) * offset);
    vec4 d = texture2D(u_tex, coord + vec2(1, 1) * offset);

    vec3 gray = grayCol;
    a.a = dot(gray, a.rgb); // TODO: dot products could be cached in alpha channel for remaining steps
    b.a = dot(gray, b.rgb);
    c.a = dot(gray, c.rgb);
    d.a = dot(gray, d.rgb);

    float bright = max(max(a.a, b.a), max(c.a, d.a));

    vec3 col = vec3(0.);
    if(a.a == bright)
        col = a.rgb;
    else if(b.a == bright)
        col = b.rgb;
    else if(c.a == bright)
        col = c.rgb;
    else
        col = d.rgb;

    gl_FragColor = vec4(col, 1.);
}