precision mediump float;

uniform sampler2D u_tex;
uniform sampler2D u_tex2;
uniform float u_alpha;

uniform vec4 u_clip;

varying vec2 coord;

void main()
{
    if(coord.x > u_clip.x && coord.x < u_clip.y
            && coord.y > u_clip.z && coord.y < u_clip.q)
        discard;

    vec4 col = texture2D(u_tex, coord);
    float mask = texture2D(u_tex2, coord).r;
    if(u_alpha > 0.) {
        gl_FragColor = u_alpha * mask * col;
    }
    else {
        float a = length(col.rgb);
        gl_FragColor = vec4(0., 0., 0., -u_alpha * mask * .5 * a);
    }
}