precision mediump float;

uniform sampler2D u_tex;
uniform sampler2D u_tex2;
uniform float u_mirrorDetector;

varying vec2 coord;

void main()
{
    float s = u_mirrorDetector;
    // u_tex2 nends to b flipped because of bmp coords
    vec3 mainCol = texture2D(u_tex, coord).rgb;
    vec3 rot0Col = texture2D(u_tex2, vec2(s,-1.) * coord).rgb;
    vec3 rot90Col = texture2D(u_tex2, vec2(s,1.) * coord.yx).rgb;
    vec3 rot180Col = texture2D(u_tex2, vec2(-s,1.) * coord).rgb;
    vec3 rot270Col = texture2D(u_tex2, vec2(-s,-1.) * coord.yx).rgb;

    vec4 orient = vec4( distance(rot0Col, mainCol), distance(rot90Col, mainCol),
                        distance(rot180Col, mainCol), distance(rot270Col, mainCol) );
    orient *= 0.578; // 1. / sqrt(3.)

    gl_FragColor = orient;//vec4(rot270Col, 1.);
}