#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;

varying vec2 coord;

#include utils

void main()
{
    vec4 rgba = texture2D(u_tex, coord); // blur[vec4(gray, darkChannel, gray * darkChannel, gray * gray)];
    float gray = rgba.r; // mean gray
    float darkChannel = rgba.g; // mean dark
    float gd = rgba.b; // correlation gray dark
    float gg = rgba.a; // correlation gray

    float variance = gg - gray * gray;
    float covariance = gd - gray * darkChannel;

    vec2 rg;
    rg.r = covariance / (variance + 0.01);
    rg.g = darkChannel - rg.r * gray;

#ifdef EXT_color_buffer_half_float
    gl_FragColor = vec4(rg.rg, 0., 0.);
#else
    gl_FragColor = vec4(pack_float16(.5 * rg.r + .5), pack_float16(.5 * rg.g + .5));
#endif
}