#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_tex3; // infoTexture with airlight
uniform sampler2D u_curves;
uniform float u_curvesRes;

varying vec2 coord;

#include utils

void main()
{
    vec3 rgb = texture2D(u_tex, coord).rgb;
    vec3 airlight = texture2D(u_tex3, coord).rgb;

    rgb = colorspace(rgb, u_curves, u_curvesRes); // TODO: This could be cached since earlier

    vec3 rgbNorm = rgb / airlight;

    float darkChannel = min(min(rgbNorm.r, rgbNorm.g), rgbNorm.b);

    gl_FragColor = vec4(rgb, darkChannel); // (p, I)
}