#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_curves;
uniform float u_curvesRes;

varying vec2 coord;

#include utils

void main()
{
    vec3 rgb = texture2D(u_tex, coord).rgb;

    // TODO: Does image need to be reuced to a specific size first?
    rgb = colorspace(rgb, u_curves, u_curvesRes);

    float darkChannel = min(min(rgb.r, rgb.g), rgb.b);

    gl_FragColor = vec4(rgb, darkChannel); // (p, I)
}