#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;

varying vec2 coord;

#include utils

void main()
{
    vec4 rgba = texture2D(u_tex, coord);

    float gray = rgba.r;
    float darkChannel = rgba.a;

    // This is part of a guided filter that preserves edges while bluring
    // Here darkChannel is being blurred with gray as the guide
    vec4 data = vec4(gray, darkChannel, gray * darkChannel, gray * gray); // (I, p, I * p, I * I)

    gl_FragColor = data;
}