#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform vec2 u_size;

varying vec2 coord;

#include utils

void main()
{
    vec4 rgba = texture2D(u_tex, coord); // center

    vec2 offset = 1. / u_size;

    float darkChannel = rgba.a;

    // Fetch smallest alpha in 3x3 area
    darkChannel = min(darkChannel, texture2D(u_tex, coord + vec2(-offset.x, -offset.y)).a);
    darkChannel = min(darkChannel, texture2D(u_tex, coord + vec2(0., -offset.y)).a);
    darkChannel = min(darkChannel, texture2D(u_tex, coord + vec2(offset.x, -offset.y)).a);

    darkChannel = min(darkChannel, texture2D(u_tex, coord + vec2(-offset.x, 0.)).a);
    darkChannel = min(darkChannel, texture2D(u_tex, coord + vec2(offset.x, 0.)).a);

    darkChannel = min(darkChannel, texture2D(u_tex, coord + vec2(-offset.x, +offset.y)).a);
    darkChannel = min(darkChannel, texture2D(u_tex, coord + vec2(0., +offset.y)).a);
    darkChannel = min(darkChannel, texture2D(u_tex, coord + vec2(offset.x, +offset.y)).a);

    float gray = dot(rgba.rgb, grayCol);

    darkChannel = clamp(1. - darkChannel, .2, 1.);

    gl_FragColor = vec4(gray, 0., 0., darkChannel);
}