#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform vec2 u_size;

uniform ivec3 u_offset; // (x-toggle, y-toggle, radius)

varying vec2 coord;

#include utils

void main()
{
    vec2 offset = vec2(float(u_offset.x), float(u_offset.y)) / u_size;
    int radius = u_offset.z;

    // TODO: This limit could be hardcoded and image instead resized to a specific size
    vec2 a = vec2(0.);
    for(int i = -radius; i <= radius; i++) {
        vec4 rgba = texture2D(u_tex, coord + float(i) * offset);
        a.x += unpack_float16(rgba.xy);
        a.y += unpack_float16(rgba.zw);
    }
    a /= float(2 * radius + 1);

    // TODO: r channel has darker upper edge

    gl_FragColor = vec4(pack_float16(a.x), pack_float16(a.y));
}