#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform vec2 u_size;

uniform ivec3 u_offset; // (x-toggle, y-toggle, radius)

varying vec2 coord;

void main()
{
    vec2 offset = vec2(float(u_offset.x), float(u_offset.y)) / u_size;
    int radius = u_offset.z;

    // TODO: This limit could be hardcoded and image instead resized to a specific size
    vec4 a = vec4(0);
    for(int i = -radius; i <= radius; i++) {
        a += texture2D(u_tex, coord + float(i) * offset);
    }
    a /= float(2 * radius + 1);

    // TODO: r channel has darker upper edge

    gl_FragColor = a;
}