#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

uniform sampler2D u_tex;
uniform sampler2D u_tex2;
uniform sampler2D u_tex3;
uniform sampler2D u_curves;
uniform float u_curvesRes;
uniform float u_alpha;

varying vec2 coord;

#include utils

vec3 RGBToHSL(vec3 color)
{
    float fmin = min(min(color.r, color.g), color.b);
    float fmax = max(max(color.r, color.g), color.b);
    float chroma = fmax - fmin;

    vec3 hsl = vec3(0., fmin, fmax);

    if (chroma != 0.0)
    {
        vec3 delta = - color / 6. / chroma;

        if (color.r == fmax )
            hsl.x = delta.b - delta.g;
        else if (color.g == fmax)
            hsl.x = (1.0 / 3.0) + delta.r - delta.b;
        else if (color.b == fmax)
            hsl.x = (2.0 / 3.0) + delta.g - delta.r;

        hsl.x = fract(hsl.x);
    }

    return hsl;
}

float HueToRGB(float fmin, float fmax, float hue)
{
    hue = fract(hue);

    float res;
    if ((6.0 * hue) < 1.0)
        res = fmin + (fmax - fmin) * 6.0 * hue;
    else if ((2.0 * hue) < 1.0)
        res = fmax;
    else if ((3.0 * hue) < 2.0)
        res = fmin + (fmax - fmin) * ((2.0 / 3.0) - hue) * 6.0;
    else
        res = fmin;

    return res;
}

vec3 HSLToRGB(vec3 hsl)
{
    vec3 rgb = vec3(0.);

    float fmin = hsl.y;
    float fmax = hsl.z;

    rgb.r = HueToRGB(fmin, fmax, hsl.x + (1.0/3.0));
    rgb.g = HueToRGB(fmin, fmax, hsl.x);
    rgb.b = HueToRGB(fmin, fmax, hsl.x - (1.0/3.0));

    return rgb;
}

void main()
{
    vec4 intermediate = texture2D(u_tex, coord);
#ifdef EXT_color_buffer_float
    float meanA = intermediate.x;
    float meanB = intermediate.y;
#else
    float meanA = 2. * unpack_float16(intermediate.xy) - 1.;
    float meanB = 2. * unpack_float16(intermediate.zw) - 1.;
#endif
    vec4 rgba = texture2D(u_tex2, coord);
    float gray = dot(rgba.rgb, grayCol);

    float trans = gray * meanA + meanB;
    trans = clamp(trans, .2, 1.);

    vec3 airlight = texture2D(u_tex3, coord).rgb;

    if(u_alpha >= 0.) {
        float map = (1. / trans - 1.) * .8 * u_alpha + 1.;
        rgba.rgb = (rgba.rgb - airlight) * map + airlight;
    }
    else {
        float map = 1. / trans;
        float strength = .8 * u_alpha;
        float scale = pow(trans - .01 * clamp(strength * -4., 0., 1.), 1. - strength * 4.);
        rgba.rgb = (rgba.rgb - airlight) * map + airlight;
        rgba.rgb = rgba.rgb * scale + (1. - scale) * airlight;
    }

    rgba.rgb = colorspaceInv(rgba.rgb, u_curves, u_curvesRes);
    rgba.a = 1.;

    gl_FragColor = rgba;
}